// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** User activities of a data warehouse. */
@Immutable
public final class DataWarehouseUserActivitiesInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private DataWarehouseUserActivitiesProperties innerProperties;

    /** Creates an instance of DataWarehouseUserActivitiesInner class. */
    public DataWarehouseUserActivitiesInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private DataWarehouseUserActivitiesProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the activeQueriesCount property: Count of running and suspended queries.
     *
     * @return the activeQueriesCount value.
     */
    public Integer activeQueriesCount() {
        return this.innerProperties() == null ? null : this.innerProperties().activeQueriesCount();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
