// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.JobExecutionLifecycle;
import com.azure.resourcemanager.sql.models.JobExecutionTarget;
import com.azure.resourcemanager.sql.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.UUID;

/** An execution of a job. */
@Fluent
public final class JobExecutionInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private JobExecutionProperties innerProperties;

    /** Creates an instance of JobExecutionInner class. */
    public JobExecutionInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private JobExecutionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the jobVersion property: The job version number.
     *
     * @return the jobVersion value.
     */
    public Integer jobVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().jobVersion();
    }

    /**
     * Get the stepName property: The job step name.
     *
     * @return the stepName value.
     */
    public String stepName() {
        return this.innerProperties() == null ? null : this.innerProperties().stepName();
    }

    /**
     * Get the stepId property: The job step id.
     *
     * @return the stepId value.
     */
    public Integer stepId() {
        return this.innerProperties() == null ? null : this.innerProperties().stepId();
    }

    /**
     * Get the jobExecutionId property: The unique identifier of the job execution.
     *
     * @return the jobExecutionId value.
     */
    public UUID jobExecutionId() {
        return this.innerProperties() == null ? null : this.innerProperties().jobExecutionId();
    }

    /**
     * Get the lifecycle property: The detailed state of the job execution.
     *
     * @return the lifecycle value.
     */
    public JobExecutionLifecycle lifecycle() {
        return this.innerProperties() == null ? null : this.innerProperties().lifecycle();
    }

    /**
     * Get the provisioningState property: The ARM provisioning state of the job execution.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the createTime property: The time that the job execution was created.
     *
     * @return the createTime value.
     */
    public OffsetDateTime createTime() {
        return this.innerProperties() == null ? null : this.innerProperties().createTime();
    }

    /**
     * Get the startTime property: The time that the job execution started.
     *
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    /**
     * Get the endTime property: The time that the job execution completed.
     *
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    /**
     * Get the currentAttempts property: Number of times the job execution has been attempted.
     *
     * @return the currentAttempts value.
     */
    public Integer currentAttempts() {
        return this.innerProperties() == null ? null : this.innerProperties().currentAttempts();
    }

    /**
     * Set the currentAttempts property: Number of times the job execution has been attempted.
     *
     * @param currentAttempts the currentAttempts value to set.
     * @return the JobExecutionInner object itself.
     */
    public JobExecutionInner withCurrentAttempts(Integer currentAttempts) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobExecutionProperties();
        }
        this.innerProperties().withCurrentAttempts(currentAttempts);
        return this;
    }

    /**
     * Get the currentAttemptStartTime property: Start time of the current attempt.
     *
     * @return the currentAttemptStartTime value.
     */
    public OffsetDateTime currentAttemptStartTime() {
        return this.innerProperties() == null ? null : this.innerProperties().currentAttemptStartTime();
    }

    /**
     * Get the lastMessage property: The last status or error message.
     *
     * @return the lastMessage value.
     */
    public String lastMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().lastMessage();
    }

    /**
     * Get the target property: The target that this execution is executed on.
     *
     * @return the target value.
     */
    public JobExecutionTarget target() {
        return this.innerProperties() == null ? null : this.innerProperties().target();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
