// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;

/** Contains the operation result properties for long term retention backup operation. */
@Immutable
public final class LongTermRetentionOperationResultProperties {
    /*
     * Request Id.
     */
    @JsonProperty(value = "requestId", access = JsonProperty.Access.WRITE_ONLY)
    private UUID requestId;

    /*
     * Operation type.
     */
    @JsonProperty(value = "operationType", access = JsonProperty.Access.WRITE_ONLY)
    private String operationType;

    /*
     * Source backup resource id
     */
    @JsonProperty(value = "fromBackupResourceId", access = JsonProperty.Access.WRITE_ONLY)
    private String fromBackupResourceId;

    /*
     * Target backup resource id
     */
    @JsonProperty(value = "toBackupResourceId", access = JsonProperty.Access.WRITE_ONLY)
    private String toBackupResourceId;

    /*
     * The storage redundancy type of the copied backup
     */
    @JsonProperty(value = "targetBackupStorageRedundancy", access = JsonProperty.Access.WRITE_ONLY)
    private BackupStorageRedundancy targetBackupStorageRedundancy;

    /*
     * Operation status
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private String status;

    /*
     * Progress message
     */
    @JsonProperty(value = "message", access = JsonProperty.Access.WRITE_ONLY)
    private String message;

    /** Creates an instance of LongTermRetentionOperationResultProperties class. */
    public LongTermRetentionOperationResultProperties() {
    }

    /**
     * Get the requestId property: Request Id.
     *
     * @return the requestId value.
     */
    public UUID requestId() {
        return this.requestId;
    }

    /**
     * Get the operationType property: Operation type.
     *
     * @return the operationType value.
     */
    public String operationType() {
        return this.operationType;
    }

    /**
     * Get the fromBackupResourceId property: Source backup resource id.
     *
     * @return the fromBackupResourceId value.
     */
    public String fromBackupResourceId() {
        return this.fromBackupResourceId;
    }

    /**
     * Get the toBackupResourceId property: Target backup resource id.
     *
     * @return the toBackupResourceId value.
     */
    public String toBackupResourceId() {
        return this.toBackupResourceId;
    }

    /**
     * Get the targetBackupStorageRedundancy property: The storage redundancy type of the copied backup.
     *
     * @return the targetBackupStorageRedundancy value.
     */
    public BackupStorageRedundancy targetBackupStorageRedundancy() {
        return this.targetBackupStorageRedundancy;
    }

    /**
     * Get the status property: Operation status.
     *
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Get the message property: Progress message.
     *
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
