// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.ServerKeyType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** A managed instance key. */
@Fluent
public final class ManagedInstanceKeyInner extends ProxyResource {
    /*
     * Kind of encryption protector. This is metadata used for the Azure portal experience.
     */
    @JsonProperty(value = "kind", access = JsonProperty.Access.WRITE_ONLY)
    private String kind;

    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private ManagedInstanceKeyProperties innerProperties;

    /** Creates an instance of ManagedInstanceKeyInner class. */
    public ManagedInstanceKeyInner() {
    }

    /**
     * Get the kind property: Kind of encryption protector. This is metadata used for the Azure portal experience.
     *
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private ManagedInstanceKeyProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the serverKeyType property: The key type like 'ServiceManaged', 'AzureKeyVault'.
     *
     * @return the serverKeyType value.
     */
    public ServerKeyType serverKeyType() {
        return this.innerProperties() == null ? null : this.innerProperties().serverKeyType();
    }

    /**
     * Set the serverKeyType property: The key type like 'ServiceManaged', 'AzureKeyVault'.
     *
     * @param serverKeyType the serverKeyType value to set.
     * @return the ManagedInstanceKeyInner object itself.
     */
    public ManagedInstanceKeyInner withServerKeyType(ServerKeyType serverKeyType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceKeyProperties();
        }
        this.innerProperties().withServerKeyType(serverKeyType);
        return this;
    }

    /**
     * Get the uri property: The URI of the key. If the ServerKeyType is AzureKeyVault, then the URI is required.
     *
     * @return the uri value.
     */
    public String uri() {
        return this.innerProperties() == null ? null : this.innerProperties().uri();
    }

    /**
     * Set the uri property: The URI of the key. If the ServerKeyType is AzureKeyVault, then the URI is required.
     *
     * @param uri the uri value to set.
     * @return the ManagedInstanceKeyInner object itself.
     */
    public ManagedInstanceKeyInner withUri(String uri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceKeyProperties();
        }
        this.innerProperties().withUri(uri);
        return this;
    }

    /**
     * Get the thumbprint property: Thumbprint of the key.
     *
     * @return the thumbprint value.
     */
    public String thumbprint() {
        return this.innerProperties() == null ? null : this.innerProperties().thumbprint();
    }

    /**
     * Get the creationDate property: The key creation date.
     *
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    /**
     * Get the autoRotationEnabled property: Key auto rotation opt-in flag. Either true or false.
     *
     * @return the autoRotationEnabled value.
     */
    public Boolean autoRotationEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().autoRotationEnabled();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
