// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Contains the properties to perform long term retention backup copy operation. */
@Fluent
public final class UpdateLongTermRetentionBackupParametersProperties {
    /*
     * The storage redundancy type of the copied backup
     */
    @JsonProperty(value = "requestedBackupStorageRedundancy")
    private BackupStorageRedundancy requestedBackupStorageRedundancy;

    /** Creates an instance of UpdateLongTermRetentionBackupParametersProperties class. */
    public UpdateLongTermRetentionBackupParametersProperties() {
    }

    /**
     * Get the requestedBackupStorageRedundancy property: The storage redundancy type of the copied backup.
     *
     * @return the requestedBackupStorageRedundancy value.
     */
    public BackupStorageRedundancy requestedBackupStorageRedundancy() {
        return this.requestedBackupStorageRedundancy;
    }

    /**
     * Set the requestedBackupStorageRedundancy property: The storage redundancy type of the copied backup.
     *
     * @param requestedBackupStorageRedundancy the requestedBackupStorageRedundancy value to set.
     * @return the UpdateLongTermRetentionBackupParametersProperties object itself.
     */
    public UpdateLongTermRetentionBackupParametersProperties withRequestedBackupStorageRedundancy(
        BackupStorageRedundancy requestedBackupStorageRedundancy) {
        this.requestedBackupStorageRedundancy = requestedBackupStorageRedundancy;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
