// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The properties of a virtual cluster. */
@Fluent
public final class VirtualClusterProperties {
    /*
     * Subnet resource ID for the virtual cluster.
     */
    @JsonProperty(value = "subnetId", access = JsonProperty.Access.WRITE_ONLY)
    private String subnetId;

    /*
     * If the service has different generations of hardware, for the same SKU, then that can be captured here.
     */
    @JsonProperty(value = "family")
    private String family;

    /*
     * List of resources in this virtual cluster.
     */
    @JsonProperty(value = "childResources", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> childResources;

    /*
     * Specifies maintenance configuration id to apply to this virtual cluster.
     */
    @JsonProperty(value = "maintenanceConfigurationId")
    private String maintenanceConfigurationId;

    /** Creates an instance of VirtualClusterProperties class. */
    public VirtualClusterProperties() {
    }

    /**
     * Get the subnetId property: Subnet resource ID for the virtual cluster.
     *
     * @return the subnetId value.
     */
    public String subnetId() {
        return this.subnetId;
    }

    /**
     * Get the family property: If the service has different generations of hardware, for the same SKU, then that can be
     * captured here.
     *
     * @return the family value.
     */
    public String family() {
        return this.family;
    }

    /**
     * Set the family property: If the service has different generations of hardware, for the same SKU, then that can be
     * captured here.
     *
     * @param family the family value to set.
     * @return the VirtualClusterProperties object itself.
     */
    public VirtualClusterProperties withFamily(String family) {
        this.family = family;
        return this;
    }

    /**
     * Get the childResources property: List of resources in this virtual cluster.
     *
     * @return the childResources value.
     */
    public List<String> childResources() {
        return this.childResources;
    }

    /**
     * Get the maintenanceConfigurationId property: Specifies maintenance configuration id to apply to this virtual
     * cluster.
     *
     * @return the maintenanceConfigurationId value.
     */
    public String maintenanceConfigurationId() {
        return this.maintenanceConfigurationId;
    }

    /**
     * Set the maintenanceConfigurationId property: Specifies maintenance configuration id to apply to this virtual
     * cluster.
     *
     * @param maintenanceConfigurationId the maintenanceConfigurationId value to set.
     * @return the VirtualClusterProperties object itself.
     */
    public VirtualClusterProperties withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        this.maintenanceConfigurationId = maintenanceConfigurationId;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
