// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName, tableName, columnName,
 * maskingFunction, and specify ruleState as disabled. However, if the rule doesn't already exist, the rule will be
 * created with ruleState set to enabled, regardless of the provided value of ruleState.
 */
public enum DataMaskingRuleState {
    /** Enum value Enabled. */
    ENABLED("Enabled"),

    /** Enum value Disabled. */
    DISABLED("Disabled");

    /** The actual serialized value for a DataMaskingRuleState instance. */
    private final String value;

    DataMaskingRuleState(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a DataMaskingRuleState instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed DataMaskingRuleState object, or null if unable to parse.
     */
    @JsonCreator
    public static DataMaskingRuleState fromString(String value) {
        if (value == null) {
            return null;
        }
        DataMaskingRuleState[] items = DataMaskingRuleState.values();
        for (DataMaskingRuleState item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
