// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for EncryptionProtectorName. */
public final class EncryptionProtectorName extends ExpandableStringEnum<EncryptionProtectorName> {
    /** Static value current for EncryptionProtectorName. */
    public static final EncryptionProtectorName CURRENT = fromString("current");

    /**
     * Creates or finds a EncryptionProtectorName from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding EncryptionProtectorName.
     */
    @JsonCreator
    public static EncryptionProtectorName fromString(String name) {
        return fromString(name, EncryptionProtectorName.class);
    }

    /**
     * Gets known EncryptionProtectorName values.
     *
     * @return known EncryptionProtectorName values.
     */
    public static Collection<EncryptionProtectorName> values() {
        return values(EncryptionProtectorName.class);
    }
}
