// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.sql.fluent.models.FirewallRuleInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** A list of server firewall rules. */
@Fluent
public final class FirewallRuleList {
    /*
     * The values property.
     */
    @JsonProperty(value = "values")
    private List<FirewallRuleInner> values;

    /** Creates an instance of FirewallRuleList class. */
    public FirewallRuleList() {
    }

    /**
     * Get the values property: The values property.
     *
     * @return the values value.
     */
    public List<FirewallRuleInner> values() {
        return this.values;
    }

    /**
     * Set the values property: The values property.
     *
     * @param values the values value to set.
     * @return the FirewallRuleList object itself.
     */
    public FirewallRuleList withValues(List<FirewallRuleInner> values) {
        this.values = values;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (values() != null) {
            values().forEach(e -> e.validate());
        }
    }
}
