// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Specifies the state of ledger digest upload. */
public enum LedgerDigestUploadsState {
    /** Enum value Enabled. */
    ENABLED("Enabled"),

    /** Enum value Disabled. */
    DISABLED("Disabled");

    /** The actual serialized value for a LedgerDigestUploadsState instance. */
    private final String value;

    LedgerDigestUploadsState(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a LedgerDigestUploadsState instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed LedgerDigestUploadsState object, or null if unable to parse.
     */
    @JsonCreator
    public static LedgerDigestUploadsState fromString(String value) {
        if (value == null) {
            return null;
        }
        LedgerDigestUploadsState[] items = LedgerDigestUploadsState.values();
        for (LedgerDigestUploadsState item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
