// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties of a topquery metric in one interval. */
@Immutable
public final class QueryMetricProperties {
    /*
     * The name information for the metric.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The UI appropriate name for the metric.
     */
    @JsonProperty(value = "displayName", access = JsonProperty.Access.WRITE_ONLY)
    private String displayName;

    /*
     * The unit of the metric.
     */
    @JsonProperty(value = "unit", access = JsonProperty.Access.WRITE_ONLY)
    private QueryMetricUnitType unit;

    /*
     * The value of the metric.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private Double value;

    /*
     * Metric value when min() aggregate function is used over the interval.
     */
    @JsonProperty(value = "min", access = JsonProperty.Access.WRITE_ONLY)
    private Double min;

    /*
     * Metric value when max() aggregate function is used over the interval.
     */
    @JsonProperty(value = "max", access = JsonProperty.Access.WRITE_ONLY)
    private Double max;

    /*
     * Metric value when avg() aggregate function is used over the interval.
     */
    @JsonProperty(value = "avg", access = JsonProperty.Access.WRITE_ONLY)
    private Double avg;

    /*
     * Metric value when sum() aggregate function is used over the interval.
     */
    @JsonProperty(value = "sum", access = JsonProperty.Access.WRITE_ONLY)
    private Double sum;

    /*
     * Metric value when stdev aggregate function is used over the interval.
     */
    @JsonProperty(value = "stdev", access = JsonProperty.Access.WRITE_ONLY)
    private Double stdev;

    /** Creates an instance of QueryMetricProperties class. */
    public QueryMetricProperties() {
    }

    /**
     * Get the name property: The name information for the metric.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the displayName property: The UI appropriate name for the metric.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Get the unit property: The unit of the metric.
     *
     * @return the unit value.
     */
    public QueryMetricUnitType unit() {
        return this.unit;
    }

    /**
     * Get the value property: The value of the metric.
     *
     * @return the value value.
     */
    public Double value() {
        return this.value;
    }

    /**
     * Get the min property: Metric value when min() aggregate function is used over the interval.
     *
     * @return the min value.
     */
    public Double min() {
        return this.min;
    }

    /**
     * Get the max property: Metric value when max() aggregate function is used over the interval.
     *
     * @return the max value.
     */
    public Double max() {
        return this.max;
    }

    /**
     * Get the avg property: Metric value when avg() aggregate function is used over the interval.
     *
     * @return the avg value.
     */
    public Double avg() {
        return this.avg;
    }

    /**
     * Get the sum property: Metric value when sum() aggregate function is used over the interval.
     *
     * @return the sum value.
     */
    public Double sum() {
        return this.sum;
    }

    /**
     * Get the stdev property: Metric value when stdev aggregate function is used over the interval.
     *
     * @return the stdev value.
     */
    public Double stdev() {
        return this.stdev;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
