// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Contains error information for an Azure SQL Database, Server or Elastic Pool Recommended Action. */
@Immutable
public final class RecommendedActionErrorInfo {
    /*
     * Gets the reason why the recommended action was put to error state. e.g., DatabaseHasQdsOff, IndexAlreadyExists
     */
    @JsonProperty(value = "errorCode", access = JsonProperty.Access.WRITE_ONLY)
    private String errorCode;

    /*
     * Gets whether the error could be ignored and recommended action could be retried. Possible values are: Yes/No
     */
    @JsonProperty(value = "isRetryable", access = JsonProperty.Access.WRITE_ONLY)
    private IsRetryable isRetryable;

    /** Creates an instance of RecommendedActionErrorInfo class. */
    public RecommendedActionErrorInfo() {
    }

    /**
     * Get the errorCode property: Gets the reason why the recommended action was put to error state. e.g.,
     * DatabaseHasQdsOff, IndexAlreadyExists.
     *
     * @return the errorCode value.
     */
    public String errorCode() {
        return this.errorCode;
    }

    /**
     * Get the isRetryable property: Gets whether the error could be ignored and recommended action could be retried.
     * Possible values are: Yes/No.
     *
     * @return the isRetryable value.
     */
    public IsRetryable isRetryable() {
        return this.isRetryable;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
