// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Contains information of estimated or observed impact on various metrics for an Azure SQL Database, Server or Elastic
 * Pool Recommended Action.
 */
@Immutable
public final class RecommendedActionImpactRecord {
    /*
     * Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange, NumberOfQueriesAffected.
     */
    @JsonProperty(value = "dimensionName", access = JsonProperty.Access.WRITE_ONLY)
    private String dimensionName;

    /*
     * Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange, NumberOfQueriesAffected.
     */
    @JsonProperty(value = "unit", access = JsonProperty.Access.WRITE_ONLY)
    private String unit;

    /*
     * Gets the absolute value of this dimension if applicable. e.g., Number of Queries affected
     */
    @JsonProperty(value = "absoluteValue", access = JsonProperty.Access.WRITE_ONLY)
    private Double absoluteValue;

    /*
     * Gets the absolute change in the value of this dimension. e.g., Absolute Disk space change in Megabytes
     */
    @JsonProperty(value = "changeValueAbsolute", access = JsonProperty.Access.WRITE_ONLY)
    private Double changeValueAbsolute;

    /*
     * Gets the relative change in the value of this dimension. e.g., Relative Disk space change in Percentage
     */
    @JsonProperty(value = "changeValueRelative", access = JsonProperty.Access.WRITE_ONLY)
    private Double changeValueRelative;

    /** Creates an instance of RecommendedActionImpactRecord class. */
    public RecommendedActionImpactRecord() {
    }

    /**
     * Get the dimensionName property: Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange,
     * NumberOfQueriesAffected.
     *
     * @return the dimensionName value.
     */
    public String dimensionName() {
        return this.dimensionName;
    }

    /**
     * Get the unit property: Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange,
     * NumberOfQueriesAffected.
     *
     * @return the unit value.
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Get the absoluteValue property: Gets the absolute value of this dimension if applicable. e.g., Number of Queries
     * affected.
     *
     * @return the absoluteValue value.
     */
    public Double absoluteValue() {
        return this.absoluteValue;
    }

    /**
     * Get the changeValueAbsolute property: Gets the absolute change in the value of this dimension. e.g., Absolute
     * Disk space change in Megabytes.
     *
     * @return the changeValueAbsolute value.
     */
    public Double changeValueAbsolute() {
        return this.changeValueAbsolute;
    }

    /**
     * Get the changeValueRelative property: Gets the relative change in the value of this dimension. e.g., Relative
     * Disk space change in Percentage.
     *
     * @return the changeValueRelative value.
     */
    public Double changeValueRelative() {
        return this.changeValueRelative;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
