/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.NetworkIsolationSettings;
import com.azure.resourcemanager.sql.models.OperationMode;
import com.azure.resourcemanager.sql.models.StorageKeyType;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class DatabaseExtensionsProperties {
    @JsonProperty(value="operationMode", required=true)
    private OperationMode operationMode;
    @JsonProperty(value="storageKeyType", required=true)
    private StorageKeyType storageKeyType;
    @JsonProperty(value="storageKey", required=true)
    private String storageKey;
    @JsonProperty(value="storageUri", required=true)
    private String storageUri;
    @JsonProperty(value="administratorLogin")
    private String administratorLogin;
    @JsonProperty(value="administratorLoginPassword")
    private String administratorLoginPassword;
    @JsonProperty(value="authenticationType")
    private String authenticationType;
    @JsonProperty(value="databaseEdition")
    private String databaseEdition;
    @JsonProperty(value="serviceObjectiveName")
    private String serviceObjectiveName;
    @JsonProperty(value="maxSizeBytes")
    private String maxSizeBytes;
    @JsonProperty(value="networkIsolation")
    private NetworkIsolationSettings networkIsolation;
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseExtensionsProperties.class);

    public OperationMode operationMode() {
        return this.operationMode;
    }

    public DatabaseExtensionsProperties withOperationMode(OperationMode operationMode) {
        this.operationMode = operationMode;
        return this;
    }

    public StorageKeyType storageKeyType() {
        return this.storageKeyType;
    }

    public DatabaseExtensionsProperties withStorageKeyType(StorageKeyType storageKeyType) {
        this.storageKeyType = storageKeyType;
        return this;
    }

    public String storageKey() {
        return this.storageKey;
    }

    public DatabaseExtensionsProperties withStorageKey(String storageKey) {
        this.storageKey = storageKey;
        return this;
    }

    public String storageUri() {
        return this.storageUri;
    }

    public DatabaseExtensionsProperties withStorageUri(String storageUri) {
        this.storageUri = storageUri;
        return this;
    }

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public DatabaseExtensionsProperties withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public DatabaseExtensionsProperties withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public String authenticationType() {
        return this.authenticationType;
    }

    public DatabaseExtensionsProperties withAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public String databaseEdition() {
        return this.databaseEdition;
    }

    public DatabaseExtensionsProperties withDatabaseEdition(String databaseEdition) {
        this.databaseEdition = databaseEdition;
        return this;
    }

    public String serviceObjectiveName() {
        return this.serviceObjectiveName;
    }

    public DatabaseExtensionsProperties withServiceObjectiveName(String serviceObjectiveName) {
        this.serviceObjectiveName = serviceObjectiveName;
        return this;
    }

    public String maxSizeBytes() {
        return this.maxSizeBytes;
    }

    public DatabaseExtensionsProperties withMaxSizeBytes(String maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    public NetworkIsolationSettings networkIsolation() {
        return this.networkIsolation;
    }

    public DatabaseExtensionsProperties withNetworkIsolation(NetworkIsolationSettings networkIsolation) {
        this.networkIsolation = networkIsolation;
        return this;
    }

    public void validate() {
        if (this.operationMode() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property operationMode in model DatabaseExtensionsProperties"));
        }
        if (this.storageKeyType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageKeyType in model DatabaseExtensionsProperties"));
        }
        if (this.storageKey() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageKey in model DatabaseExtensionsProperties"));
        }
        if (this.storageUri() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageUri in model DatabaseExtensionsProperties"));
        }
        if (this.networkIsolation() != null) {
            this.networkIsolation().validate();
        }
    }
}

