/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.RecommendedElasticPoolsClient;
import com.azure.resourcemanager.sql.fluent.models.RecommendedElasticPoolInner;
import com.azure.resourcemanager.sql.fluent.models.RecommendedElasticPoolMetricInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.RecommendedElasticPoolListMetricsResult;
import com.azure.resourcemanager.sql.models.RecommendedElasticPoolListResult;
import reactor.core.publisher.Mono;

public final class RecommendedElasticPoolsClientImpl
implements RecommendedElasticPoolsClient {
    private final ClientLogger logger = new ClientLogger(RecommendedElasticPoolsClientImpl.class);
    private final RecommendedElasticPoolsService service;
    private final SqlManagementClientImpl client;

    RecommendedElasticPoolsClientImpl(SqlManagementClientImpl client) {
        this.service = (RecommendedElasticPoolsService)RestProxy.create(RecommendedElasticPoolsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<RecommendedElasticPoolInner>> getWithResponseAsync(String resourceGroupName, String serverName, String recommendedElasticPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (recommendedElasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recommendedElasticPoolName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, recommendedElasticPoolName, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<RecommendedElasticPoolInner>> getWithResponseAsync(String resourceGroupName, String serverName, String recommendedElasticPoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (recommendedElasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recommendedElasticPoolName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, recommendedElasticPoolName, context);
    }

    @Override
    public Mono<RecommendedElasticPoolInner> getAsync(String resourceGroupName, String serverName, String recommendedElasticPoolName) {
        return this.getWithResponseAsync(resourceGroupName, serverName, recommendedElasticPoolName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RecommendedElasticPoolInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public RecommendedElasticPoolInner get(String resourceGroupName, String serverName, String recommendedElasticPoolName) {
        return (RecommendedElasticPoolInner)((Object)this.getAsync(resourceGroupName, serverName, recommendedElasticPoolName).block());
    }

    @Override
    public Response<RecommendedElasticPoolInner> getWithResponse(String resourceGroupName, String serverName, String recommendedElasticPoolName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, recommendedElasticPoolName, context).block();
    }

    private Mono<PagedResponse<RecommendedElasticPoolInner>> listByServerSinglePageAsync(String resourceGroupName, String serverName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        return FluxUtil.withContext(context -> this.service.listByServer(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendedElasticPoolListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<RecommendedElasticPoolInner>> listByServerSinglePageAsync(String resourceGroupName, String serverName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        context = this.client.mergeContext(context);
        return this.service.listByServer(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendedElasticPoolListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<RecommendedElasticPoolInner> listByServerAsync(String resourceGroupName, String serverName) {
        return new PagedFlux(() -> this.listByServerSinglePageAsync(resourceGroupName, serverName));
    }

    private PagedFlux<RecommendedElasticPoolInner> listByServerAsync(String resourceGroupName, String serverName, Context context) {
        return new PagedFlux(() -> this.listByServerSinglePageAsync(resourceGroupName, serverName, context));
    }

    @Override
    public PagedIterable<RecommendedElasticPoolInner> listByServer(String resourceGroupName, String serverName) {
        return new PagedIterable(this.listByServerAsync(resourceGroupName, serverName));
    }

    @Override
    public PagedIterable<RecommendedElasticPoolInner> listByServer(String resourceGroupName, String serverName, Context context) {
        return new PagedIterable(this.listByServerAsync(resourceGroupName, serverName, context));
    }

    private Mono<PagedResponse<RecommendedElasticPoolMetricInner>> listMetricsSinglePageAsync(String resourceGroupName, String serverName, String recommendedElasticPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (recommendedElasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recommendedElasticPoolName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        return FluxUtil.withContext(context -> this.service.listMetrics(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, recommendedElasticPoolName, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendedElasticPoolListMetricsResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<RecommendedElasticPoolMetricInner>> listMetricsSinglePageAsync(String resourceGroupName, String serverName, String recommendedElasticPoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (recommendedElasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recommendedElasticPoolName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        context = this.client.mergeContext(context);
        return this.service.listMetrics(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, recommendedElasticPoolName, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendedElasticPoolListMetricsResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<RecommendedElasticPoolMetricInner> listMetricsAsync(String resourceGroupName, String serverName, String recommendedElasticPoolName) {
        return new PagedFlux(() -> this.listMetricsSinglePageAsync(resourceGroupName, serverName, recommendedElasticPoolName));
    }

    private PagedFlux<RecommendedElasticPoolMetricInner> listMetricsAsync(String resourceGroupName, String serverName, String recommendedElasticPoolName, Context context) {
        return new PagedFlux(() -> this.listMetricsSinglePageAsync(resourceGroupName, serverName, recommendedElasticPoolName, context));
    }

    @Override
    public PagedIterable<RecommendedElasticPoolMetricInner> listMetrics(String resourceGroupName, String serverName, String recommendedElasticPoolName) {
        return new PagedIterable(this.listMetricsAsync(resourceGroupName, serverName, recommendedElasticPoolName));
    }

    @Override
    public PagedIterable<RecommendedElasticPoolMetricInner> listMetrics(String resourceGroupName, String serverName, String recommendedElasticPoolName, Context context) {
        return new PagedIterable(this.listMetricsAsync(resourceGroupName, serverName, recommendedElasticPoolName, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientR")
    private static interface RecommendedElasticPoolsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/recommendedElasticPools/{recommendedElasticPoolName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecommendedElasticPoolInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @PathParam(value="recommendedElasticPoolName") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/recommendedElasticPools")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecommendedElasticPoolListResult>> listByServer(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/recommendedElasticPools/{recommendedElasticPoolName}/metrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecommendedElasticPoolListMetricsResult>> listMetrics(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @PathParam(value="recommendedElasticPoolName") String var6, Context var7);
    }
}

