/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.TransparentDataEncryptionsClient;
import com.azure.resourcemanager.sql.fluent.models.TransparentDataEncryptionInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.TransparentDataEncryptionName;
import com.azure.resourcemanager.sql.models.TransparentDataEncryptionStatus;
import reactor.core.publisher.Mono;

public final class TransparentDataEncryptionsClientImpl
implements TransparentDataEncryptionsClient {
    private final ClientLogger logger = new ClientLogger(TransparentDataEncryptionsClientImpl.class);
    private final TransparentDataEncryptionsService service;
    private final SqlManagementClientImpl client;

    TransparentDataEncryptionsClientImpl(SqlManagementClientImpl client) {
        this.service = (TransparentDataEncryptionsService)RestProxy.create(TransparentDataEncryptionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<TransparentDataEncryptionInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionName transparentDataEncryptionName, TransparentDataEncryptionStatus status) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (transparentDataEncryptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter transparentDataEncryptionName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        TransparentDataEncryptionInner parameters = new TransparentDataEncryptionInner();
        parameters.withStatus(status);
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, databaseName, transparentDataEncryptionName, parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<TransparentDataEncryptionInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionName transparentDataEncryptionName, TransparentDataEncryptionStatus status, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (transparentDataEncryptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter transparentDataEncryptionName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        TransparentDataEncryptionInner parameters = new TransparentDataEncryptionInner();
        parameters.withStatus(status);
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, databaseName, transparentDataEncryptionName, parameters, context);
    }

    @Override
    public Mono<TransparentDataEncryptionInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionName transparentDataEncryptionName, TransparentDataEncryptionStatus status) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, transparentDataEncryptionName, status).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((TransparentDataEncryptionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<TransparentDataEncryptionInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionName transparentDataEncryptionName) {
        TransparentDataEncryptionStatus status = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, transparentDataEncryptionName, status).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((TransparentDataEncryptionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public TransparentDataEncryptionInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionName transparentDataEncryptionName) {
        TransparentDataEncryptionStatus status = null;
        return (TransparentDataEncryptionInner)((Object)this.createOrUpdateAsync(resourceGroupName, serverName, databaseName, transparentDataEncryptionName, status).block());
    }

    @Override
    public Response<TransparentDataEncryptionInner> createOrUpdateWithResponse(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionName transparentDataEncryptionName, TransparentDataEncryptionStatus status, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, transparentDataEncryptionName, status, context).block();
    }

    @Override
    public Mono<Response<TransparentDataEncryptionInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionName transparentDataEncryptionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (transparentDataEncryptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter transparentDataEncryptionName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, databaseName, transparentDataEncryptionName, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<TransparentDataEncryptionInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionName transparentDataEncryptionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (transparentDataEncryptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter transparentDataEncryptionName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, databaseName, transparentDataEncryptionName, context);
    }

    @Override
    public Mono<TransparentDataEncryptionInner> getAsync(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionName transparentDataEncryptionName) {
        return this.getWithResponseAsync(resourceGroupName, serverName, databaseName, transparentDataEncryptionName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((TransparentDataEncryptionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public TransparentDataEncryptionInner get(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionName transparentDataEncryptionName) {
        return (TransparentDataEncryptionInner)((Object)this.getAsync(resourceGroupName, serverName, databaseName, transparentDataEncryptionName).block());
    }

    @Override
    public Response<TransparentDataEncryptionInner> getWithResponse(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionName transparentDataEncryptionName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, databaseName, transparentDataEncryptionName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientT")
    private static interface TransparentDataEncryptionsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/transparentDataEncryption/{transparentDataEncryptionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TransparentDataEncryptionInner>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @PathParam(value="databaseName") String var6, @PathParam(value="transparentDataEncryptionName") TransparentDataEncryptionName var7, @BodyParam(value="application/json") TransparentDataEncryptionInner var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/transparentDataEncryption/{transparentDataEncryptionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TransparentDataEncryptionInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @PathParam(value="databaseName") String var6, @PathParam(value="transparentDataEncryptionName") TransparentDataEncryptionName var7, Context var8);
    }
}

