// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentRecurringScansProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A database vulnerability assessment. */
@Fluent
public final class DatabaseVulnerabilityAssessmentInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private DatabaseVulnerabilityAssessmentProperties innerProperties;

    /** Creates an instance of DatabaseVulnerabilityAssessmentInner class. */
    public DatabaseVulnerabilityAssessmentInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private DatabaseVulnerabilityAssessmentProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the storageContainerPath property: A blob storage container path to hold the scan results (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/). It is required if server level vulnerability assessment policy
     * doesn't set.
     *
     * @return the storageContainerPath value.
     */
    public String storageContainerPath() {
        return this.innerProperties() == null ? null : this.innerProperties().storageContainerPath();
    }

    /**
     * Set the storageContainerPath property: A blob storage container path to hold the scan results (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/). It is required if server level vulnerability assessment policy
     * doesn't set.
     *
     * @param storageContainerPath the storageContainerPath value to set.
     * @return the DatabaseVulnerabilityAssessmentInner object itself.
     */
    public DatabaseVulnerabilityAssessmentInner withStorageContainerPath(String storageContainerPath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseVulnerabilityAssessmentProperties();
        }
        this.innerProperties().withStorageContainerPath(storageContainerPath);
        return this;
    }

    /**
     * Get the storageContainerSasKey property: A shared access signature (SAS Key) that has write access to the blob
     * container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified,
     * StorageContainerSasKey is required. Applies only if the storage account is not behind a Vnet or a firewall.
     *
     * @return the storageContainerSasKey value.
     */
    public String storageContainerSasKey() {
        return this.innerProperties() == null ? null : this.innerProperties().storageContainerSasKey();
    }

    /**
     * Set the storageContainerSasKey property: A shared access signature (SAS Key) that has write access to the blob
     * container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified,
     * StorageContainerSasKey is required. Applies only if the storage account is not behind a Vnet or a firewall.
     *
     * @param storageContainerSasKey the storageContainerSasKey value to set.
     * @return the DatabaseVulnerabilityAssessmentInner object itself.
     */
    public DatabaseVulnerabilityAssessmentInner withStorageContainerSasKey(String storageContainerSasKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseVulnerabilityAssessmentProperties();
        }
        this.innerProperties().withStorageContainerSasKey(storageContainerSasKey);
        return this;
    }

    /**
     * Get the storageAccountAccessKey property: Specifies the identifier key of the storage account for vulnerability
     * assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
     * Applies only if the storage account is not behind a Vnet or a firewall.
     *
     * @return the storageAccountAccessKey value.
     */
    public String storageAccountAccessKey() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAccountAccessKey();
    }

    /**
     * Set the storageAccountAccessKey property: Specifies the identifier key of the storage account for vulnerability
     * assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
     * Applies only if the storage account is not behind a Vnet or a firewall.
     *
     * @param storageAccountAccessKey the storageAccountAccessKey value to set.
     * @return the DatabaseVulnerabilityAssessmentInner object itself.
     */
    public DatabaseVulnerabilityAssessmentInner withStorageAccountAccessKey(String storageAccountAccessKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseVulnerabilityAssessmentProperties();
        }
        this.innerProperties().withStorageAccountAccessKey(storageAccountAccessKey);
        return this;
    }

    /**
     * Get the recurringScans property: The recurring scans settings.
     *
     * @return the recurringScans value.
     */
    public VulnerabilityAssessmentRecurringScansProperties recurringScans() {
        return this.innerProperties() == null ? null : this.innerProperties().recurringScans();
    }

    /**
     * Set the recurringScans property: The recurring scans settings.
     *
     * @param recurringScans the recurringScans value to set.
     * @return the DatabaseVulnerabilityAssessmentInner object itself.
     */
    public DatabaseVulnerabilityAssessmentInner withRecurringScans(
        VulnerabilityAssessmentRecurringScansProperties recurringScans) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseVulnerabilityAssessmentProperties();
        }
        this.innerProperties().withRecurringScans(recurringScans);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
