// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.LedgerDigestUploadsState;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Azure SQL Database ledger digest upload settings. */
@Fluent
public final class LedgerDigestUploadsInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private LedgerDigestUploadsProperties innerProperties;

    /** Creates an instance of LedgerDigestUploadsInner class. */
    public LedgerDigestUploadsInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private LedgerDigestUploadsProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the digestStorageEndpoint property: The digest storage endpoint, which must be either an Azure blob storage
     * endpoint or an URI for Azure Confidential Ledger.
     *
     * @return the digestStorageEndpoint value.
     */
    public String digestStorageEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().digestStorageEndpoint();
    }

    /**
     * Set the digestStorageEndpoint property: The digest storage endpoint, which must be either an Azure blob storage
     * endpoint or an URI for Azure Confidential Ledger.
     *
     * @param digestStorageEndpoint the digestStorageEndpoint value to set.
     * @return the LedgerDigestUploadsInner object itself.
     */
    public LedgerDigestUploadsInner withDigestStorageEndpoint(String digestStorageEndpoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LedgerDigestUploadsProperties();
        }
        this.innerProperties().withDigestStorageEndpoint(digestStorageEndpoint);
        return this;
    }

    /**
     * Get the state property: Specifies the state of ledger digest upload.
     *
     * @return the state value.
     */
    public LedgerDigestUploadsState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
