// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.MaintenanceWindowTimeRange;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Maintenance window options. */
@Fluent
public final class MaintenanceWindowOptionsInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private MaintenanceWindowOptionsProperties innerProperties;

    /** Creates an instance of MaintenanceWindowOptionsInner class. */
    public MaintenanceWindowOptionsInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private MaintenanceWindowOptionsProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the isEnabled property: Whether maintenance windows are enabled for the database.
     *
     * @return the isEnabled value.
     */
    public Boolean isEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isEnabled();
    }

    /**
     * Set the isEnabled property: Whether maintenance windows are enabled for the database.
     *
     * @param isEnabled the isEnabled value to set.
     * @return the MaintenanceWindowOptionsInner object itself.
     */
    public MaintenanceWindowOptionsInner withIsEnabled(Boolean isEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MaintenanceWindowOptionsProperties();
        }
        this.innerProperties().withIsEnabled(isEnabled);
        return this;
    }

    /**
     * Get the maintenanceWindowCycles property: Available maintenance cycles e.g. {Saturday, 0, 48*60}, {Wednesday, 0,
     * 24*60}.
     *
     * @return the maintenanceWindowCycles value.
     */
    public List<MaintenanceWindowTimeRange> maintenanceWindowCycles() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceWindowCycles();
    }

    /**
     * Set the maintenanceWindowCycles property: Available maintenance cycles e.g. {Saturday, 0, 48*60}, {Wednesday, 0,
     * 24*60}.
     *
     * @param maintenanceWindowCycles the maintenanceWindowCycles value to set.
     * @return the MaintenanceWindowOptionsInner object itself.
     */
    public MaintenanceWindowOptionsInner withMaintenanceWindowCycles(
        List<MaintenanceWindowTimeRange> maintenanceWindowCycles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MaintenanceWindowOptionsProperties();
        }
        this.innerProperties().withMaintenanceWindowCycles(maintenanceWindowCycles);
        return this;
    }

    /**
     * Get the minDurationInMinutes property: Minimum duration of maintenance window.
     *
     * @return the minDurationInMinutes value.
     */
    public Integer minDurationInMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().minDurationInMinutes();
    }

    /**
     * Set the minDurationInMinutes property: Minimum duration of maintenance window.
     *
     * @param minDurationInMinutes the minDurationInMinutes value to set.
     * @return the MaintenanceWindowOptionsInner object itself.
     */
    public MaintenanceWindowOptionsInner withMinDurationInMinutes(Integer minDurationInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MaintenanceWindowOptionsProperties();
        }
        this.innerProperties().withMinDurationInMinutes(minDurationInMinutes);
        return this;
    }

    /**
     * Get the defaultDurationInMinutes property: Default duration for maintenance window.
     *
     * @return the defaultDurationInMinutes value.
     */
    public Integer defaultDurationInMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultDurationInMinutes();
    }

    /**
     * Set the defaultDurationInMinutes property: Default duration for maintenance window.
     *
     * @param defaultDurationInMinutes the defaultDurationInMinutes value to set.
     * @return the MaintenanceWindowOptionsInner object itself.
     */
    public MaintenanceWindowOptionsInner withDefaultDurationInMinutes(Integer defaultDurationInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MaintenanceWindowOptionsProperties();
        }
        this.innerProperties().withDefaultDurationInMinutes(defaultDurationInMinutes);
        return this;
    }

    /**
     * Get the minCycles property: Minimum number of maintenance windows cycles to be set on the database.
     *
     * @return the minCycles value.
     */
    public Integer minCycles() {
        return this.innerProperties() == null ? null : this.innerProperties().minCycles();
    }

    /**
     * Set the minCycles property: Minimum number of maintenance windows cycles to be set on the database.
     *
     * @param minCycles the minCycles value to set.
     * @return the MaintenanceWindowOptionsInner object itself.
     */
    public MaintenanceWindowOptionsInner withMinCycles(Integer minCycles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MaintenanceWindowOptionsProperties();
        }
        this.innerProperties().withMinCycles(minCycles);
        return this;
    }

    /**
     * Get the timeGranularityInMinutes property: Time granularity in minutes for maintenance windows.
     *
     * @return the timeGranularityInMinutes value.
     */
    public Integer timeGranularityInMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().timeGranularityInMinutes();
    }

    /**
     * Set the timeGranularityInMinutes property: Time granularity in minutes for maintenance windows.
     *
     * @param timeGranularityInMinutes the timeGranularityInMinutes value to set.
     * @return the MaintenanceWindowOptionsInner object itself.
     */
    public MaintenanceWindowOptionsInner withTimeGranularityInMinutes(Integer timeGranularityInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MaintenanceWindowOptionsProperties();
        }
        this.innerProperties().withTimeGranularityInMinutes(timeGranularityInMinutes);
        return this;
    }

    /**
     * Get the allowMultipleMaintenanceWindowsPerCycle property: Whether we allow multiple maintenance windows per
     * cycle.
     *
     * @return the allowMultipleMaintenanceWindowsPerCycle value.
     */
    public Boolean allowMultipleMaintenanceWindowsPerCycle() {
        return this.innerProperties() == null ? null : this.innerProperties().allowMultipleMaintenanceWindowsPerCycle();
    }

    /**
     * Set the allowMultipleMaintenanceWindowsPerCycle property: Whether we allow multiple maintenance windows per
     * cycle.
     *
     * @param allowMultipleMaintenanceWindowsPerCycle the allowMultipleMaintenanceWindowsPerCycle value to set.
     * @return the MaintenanceWindowOptionsInner object itself.
     */
    public MaintenanceWindowOptionsInner withAllowMultipleMaintenanceWindowsPerCycle(
        Boolean allowMultipleMaintenanceWindowsPerCycle) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MaintenanceWindowOptionsProperties();
        }
        this.innerProperties().withAllowMultipleMaintenanceWindowsPerCycle(allowMultipleMaintenanceWindowsPerCycle);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
