// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A managed server DNS alias. */
@Immutable
public final class ManagedServerDnsAliasInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private ManagedServerDnsAliasProperties innerProperties;

    /** Creates an instance of ManagedServerDnsAliasInner class. */
    public ManagedServerDnsAliasInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private ManagedServerDnsAliasProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the azureDnsRecord property: The fully qualified DNS record for managed server alias.
     *
     * @return the azureDnsRecord value.
     */
    public String azureDnsRecord() {
        return this.innerProperties() == null ? null : this.innerProperties().azureDnsRecord();
    }

    /**
     * Get the publicAzureDnsRecord property: The fully qualified public DNS record for managed server alias.
     *
     * @return the publicAzureDnsRecord value.
     */
    public String publicAzureDnsRecord() {
        return this.innerProperties() == null ? null : this.innerProperties().publicAzureDnsRecord();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
