// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.RestorePointType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Database restore points. */
@Immutable
public final class RestorePointInner extends ProxyResource {
    /*
     * Resource location.
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private RestorePointProperties innerProperties;

    /** Creates an instance of RestorePointInner class. */
    public RestorePointInner() {
    }

    /**
     * Get the location property: Resource location.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private RestorePointProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the restorePointType property: The type of restore point.
     *
     * @return the restorePointType value.
     */
    public RestorePointType restorePointType() {
        return this.innerProperties() == null ? null : this.innerProperties().restorePointType();
    }

    /**
     * Get the earliestRestoreDate property: The earliest time to which this database can be restored.
     *
     * @return the earliestRestoreDate value.
     */
    public OffsetDateTime earliestRestoreDate() {
        return this.innerProperties() == null ? null : this.innerProperties().earliestRestoreDate();
    }

    /**
     * Get the restorePointCreationDate property: The time the backup was taken.
     *
     * @return the restorePointCreationDate value.
     */
    public OffsetDateTime restorePointCreationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().restorePointCreationDate();
    }

    /**
     * Get the restorePointLabel property: The label of restore point for backup request by user.
     *
     * @return the restorePointLabel value.
     */
    public String restorePointLabel() {
        return this.innerProperties() == null ? null : this.innerProperties().restorePointLabel();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
