// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** An Azure SQL virtual cluster. */
@Fluent
public final class VirtualClusterInner extends Resource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private VirtualClusterProperties innerProperties;

    /** Creates an instance of VirtualClusterInner class. */
    public VirtualClusterInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private VirtualClusterProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public VirtualClusterInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public VirtualClusterInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the subnetId property: Subnet resource ID for the virtual cluster.
     *
     * @return the subnetId value.
     */
    public String subnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetId();
    }

    /**
     * Get the family property: If the service has different generations of hardware, for the same SKU, then that can be
     * captured here.
     *
     * @return the family value.
     */
    public String family() {
        return this.innerProperties() == null ? null : this.innerProperties().family();
    }

    /**
     * Set the family property: If the service has different generations of hardware, for the same SKU, then that can be
     * captured here.
     *
     * @param family the family value to set.
     * @return the VirtualClusterInner object itself.
     */
    public VirtualClusterInner withFamily(String family) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualClusterProperties();
        }
        this.innerProperties().withFamily(family);
        return this;
    }

    /**
     * Get the childResources property: List of resources in this virtual cluster.
     *
     * @return the childResources value.
     */
    public List<String> childResources() {
        return this.innerProperties() == null ? null : this.innerProperties().childResources();
    }

    /**
     * Get the maintenanceConfigurationId property: Specifies maintenance configuration id to apply to this virtual
     * cluster.
     *
     * @return the maintenanceConfigurationId value.
     */
    public String maintenanceConfigurationId() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceConfigurationId();
    }

    /**
     * Set the maintenanceConfigurationId property: Specifies maintenance configuration id to apply to this virtual
     * cluster.
     *
     * @param maintenanceConfigurationId the maintenanceConfigurationId value to set.
     * @return the VirtualClusterInner object itself.
     */
    public VirtualClusterInner withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualClusterProperties();
        }
        this.innerProperties().withMaintenanceConfigurationId(maintenanceConfigurationId);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
