// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Contains the information necessary to start a managed database move. */
@Fluent
public final class ManagedDatabaseStartMoveDefinition {
    /*
     * The destination managed database ID
     */
    @JsonProperty(value = "destinationManagedDatabaseId", required = true)
    private String destinationManagedDatabaseId;

    /*
     * The move operation mode.
     */
    @JsonProperty(value = "operationMode")
    private MoveOperationMode operationMode;

    /** Creates an instance of ManagedDatabaseStartMoveDefinition class. */
    public ManagedDatabaseStartMoveDefinition() {
    }

    /**
     * Get the destinationManagedDatabaseId property: The destination managed database ID.
     *
     * @return the destinationManagedDatabaseId value.
     */
    public String destinationManagedDatabaseId() {
        return this.destinationManagedDatabaseId;
    }

    /**
     * Set the destinationManagedDatabaseId property: The destination managed database ID.
     *
     * @param destinationManagedDatabaseId the destinationManagedDatabaseId value to set.
     * @return the ManagedDatabaseStartMoveDefinition object itself.
     */
    public ManagedDatabaseStartMoveDefinition withDestinationManagedDatabaseId(String destinationManagedDatabaseId) {
        this.destinationManagedDatabaseId = destinationManagedDatabaseId;
        return this;
    }

    /**
     * Get the operationMode property: The move operation mode.
     *
     * @return the operationMode value.
     */
    public MoveOperationMode operationMode() {
        return this.operationMode;
    }

    /**
     * Set the operationMode property: The move operation mode.
     *
     * @param operationMode the operationMode value to set.
     * @return the ManagedDatabaseStartMoveDefinition object itself.
     */
    public ManagedDatabaseStartMoveDefinition withOperationMode(MoveOperationMode operationMode) {
        this.operationMode = operationMode;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (destinationManagedDatabaseId() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property destinationManagedDatabaseId in model"
                            + " ManagedDatabaseStartMoveDefinition"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedDatabaseStartMoveDefinition.class);
}
