// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The managed instance's service principal configuration for a resource. */
@Fluent
public final class ServicePrincipal {
    /*
     * The Azure Active Directory application object id.
     */
    @JsonProperty(value = "principalId", access = JsonProperty.Access.WRITE_ONLY)
    private String principalId;

    /*
     * The Azure Active Directory application client id.
     */
    @JsonProperty(value = "clientId", access = JsonProperty.Access.WRITE_ONLY)
    private String clientId;

    /*
     * The Azure Active Directory tenant id.
     */
    @JsonProperty(value = "tenantId", access = JsonProperty.Access.WRITE_ONLY)
    private String tenantId;

    /*
     * Service principal type.
     */
    @JsonProperty(value = "type")
    private ServicePrincipalType type;

    /** Creates an instance of ServicePrincipal class. */
    public ServicePrincipal() {
    }

    /**
     * Get the principalId property: The Azure Active Directory application object id.
     *
     * @return the principalId value.
     */
    public String principalId() {
        return this.principalId;
    }

    /**
     * Get the clientId property: The Azure Active Directory application client id.
     *
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Get the tenantId property: The Azure Active Directory tenant id.
     *
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Get the type property: Service principal type.
     *
     * @return the type value.
     */
    public ServicePrincipalType type() {
        return this.type;
    }

    /**
     * Set the type property: Service principal type.
     *
     * @param type the type value to set.
     * @return the ServicePrincipal object itself.
     */
    public ServicePrincipal withType(ServicePrincipalType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
