// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.fluent.models.TdeCertificateProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A TDE certificate that can be uploaded into a server. */
@Fluent
public final class TdeCertificate extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private TdeCertificateProperties innerProperties;

    /** Creates an instance of TdeCertificate class. */
    public TdeCertificate() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private TdeCertificateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the privateBlob property: The base64 encoded certificate private blob.
     *
     * @return the privateBlob value.
     */
    public String privateBlob() {
        return this.innerProperties() == null ? null : this.innerProperties().privateBlob();
    }

    /**
     * Set the privateBlob property: The base64 encoded certificate private blob.
     *
     * @param privateBlob the privateBlob value to set.
     * @return the TdeCertificate object itself.
     */
    public TdeCertificate withPrivateBlob(String privateBlob) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TdeCertificateProperties();
        }
        this.innerProperties().withPrivateBlob(privateBlob);
        return this;
    }

    /**
     * Get the certPassword property: The certificate password.
     *
     * @return the certPassword value.
     */
    public String certPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().certPassword();
    }

    /**
     * Set the certPassword property: The certificate password.
     *
     * @param certPassword the certPassword value to set.
     * @return the TdeCertificate object itself.
     */
    public TdeCertificate withCertPassword(String certPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TdeCertificateProperties();
        }
        this.innerProperties().withCertPassword(certPassword);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
