/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import com.azure.resourcemanager.sql.models.CatalogCollationType;
import com.azure.resourcemanager.sql.models.CreateMode;
import com.azure.resourcemanager.sql.models.DatabaseLicenseType;
import com.azure.resourcemanager.sql.models.DatabaseReadScale;
import com.azure.resourcemanager.sql.models.DatabaseStatus;
import com.azure.resourcemanager.sql.models.SampleName;
import com.azure.resourcemanager.sql.models.SecondaryType;
import com.azure.resourcemanager.sql.models.Sku;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.UUID;

public final class DatabaseProperties {
    @JsonProperty(value="createMode")
    private CreateMode createMode;
    @JsonProperty(value="collation")
    private String collation;
    @JsonProperty(value="maxSizeBytes")
    private Long maxSizeBytes;
    @JsonProperty(value="sampleName")
    private SampleName sampleName;
    @JsonProperty(value="elasticPoolId")
    private String elasticPoolId;
    @JsonProperty(value="sourceDatabaseId")
    private String sourceDatabaseId;
    @JsonProperty(value="status", access=JsonProperty.Access.WRITE_ONLY)
    private DatabaseStatus status;
    @JsonProperty(value="databaseId", access=JsonProperty.Access.WRITE_ONLY)
    private UUID databaseId;
    @JsonProperty(value="creationDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationDate;
    @JsonProperty(value="currentServiceObjectiveName", access=JsonProperty.Access.WRITE_ONLY)
    private String currentServiceObjectiveName;
    @JsonProperty(value="requestedServiceObjectiveName", access=JsonProperty.Access.WRITE_ONLY)
    private String requestedServiceObjectiveName;
    @JsonProperty(value="defaultSecondaryLocation", access=JsonProperty.Access.WRITE_ONLY)
    private String defaultSecondaryLocation;
    @JsonProperty(value="failoverGroupId", access=JsonProperty.Access.WRITE_ONLY)
    private String failoverGroupId;
    @JsonProperty(value="restorePointInTime")
    private OffsetDateTime restorePointInTime;
    @JsonProperty(value="sourceDatabaseDeletionDate")
    private OffsetDateTime sourceDatabaseDeletionDate;
    @JsonProperty(value="recoveryServicesRecoveryPointId")
    private String recoveryServicesRecoveryPointId;
    @JsonProperty(value="longTermRetentionBackupResourceId")
    private String longTermRetentionBackupResourceId;
    @JsonProperty(value="recoverableDatabaseId")
    private String recoverableDatabaseId;
    @JsonProperty(value="restorableDroppedDatabaseId")
    private String restorableDroppedDatabaseId;
    @JsonProperty(value="catalogCollation")
    private CatalogCollationType catalogCollation;
    @JsonProperty(value="zoneRedundant")
    private Boolean zoneRedundant;
    @JsonProperty(value="licenseType")
    private DatabaseLicenseType licenseType;
    @JsonProperty(value="maxLogSizeBytes", access=JsonProperty.Access.WRITE_ONLY)
    private Long maxLogSizeBytes;
    @JsonProperty(value="earliestRestoreDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime earliestRestoreDate;
    @JsonProperty(value="readScale")
    private DatabaseReadScale readScale;
    @JsonProperty(value="highAvailabilityReplicaCount")
    private Integer highAvailabilityReplicaCount;
    @JsonProperty(value="secondaryType")
    private SecondaryType secondaryType;
    @JsonProperty(value="currentSku", access=JsonProperty.Access.WRITE_ONLY)
    private Sku currentSku;
    @JsonProperty(value="autoPauseDelay")
    private Integer autoPauseDelay;
    @JsonProperty(value="currentBackupStorageRedundancy", access=JsonProperty.Access.WRITE_ONLY)
    private BackupStorageRedundancy currentBackupStorageRedundancy;
    @JsonProperty(value="requestedBackupStorageRedundancy")
    private BackupStorageRedundancy requestedBackupStorageRedundancy;
    @JsonProperty(value="minCapacity")
    private Double minCapacity;
    @JsonProperty(value="pausedDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime pausedDate;
    @JsonProperty(value="resumedDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime resumedDate;
    @JsonProperty(value="maintenanceConfigurationId")
    private String maintenanceConfigurationId;
    @JsonProperty(value="isLedgerOn")
    private Boolean isLedgerOn;
    @JsonProperty(value="isInfraEncryptionEnabled", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isInfraEncryptionEnabled;
    @JsonProperty(value="federatedClientId")
    private UUID federatedClientId;
    @JsonProperty(value="sourceResourceId")
    private String sourceResourceId;

    public CreateMode createMode() {
        return this.createMode;
    }

    public DatabaseProperties withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public String collation() {
        return this.collation;
    }

    public DatabaseProperties withCollation(String collation) {
        this.collation = collation;
        return this;
    }

    public Long maxSizeBytes() {
        return this.maxSizeBytes;
    }

    public DatabaseProperties withMaxSizeBytes(Long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    public SampleName sampleName() {
        return this.sampleName;
    }

    public DatabaseProperties withSampleName(SampleName sampleName) {
        this.sampleName = sampleName;
        return this;
    }

    public String elasticPoolId() {
        return this.elasticPoolId;
    }

    public DatabaseProperties withElasticPoolId(String elasticPoolId) {
        this.elasticPoolId = elasticPoolId;
        return this;
    }

    public String sourceDatabaseId() {
        return this.sourceDatabaseId;
    }

    public DatabaseProperties withSourceDatabaseId(String sourceDatabaseId) {
        this.sourceDatabaseId = sourceDatabaseId;
        return this;
    }

    public DatabaseStatus status() {
        return this.status;
    }

    public UUID databaseId() {
        return this.databaseId;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public String currentServiceObjectiveName() {
        return this.currentServiceObjectiveName;
    }

    public String requestedServiceObjectiveName() {
        return this.requestedServiceObjectiveName;
    }

    public String defaultSecondaryLocation() {
        return this.defaultSecondaryLocation;
    }

    public String failoverGroupId() {
        return this.failoverGroupId;
    }

    public OffsetDateTime restorePointInTime() {
        return this.restorePointInTime;
    }

    public DatabaseProperties withRestorePointInTime(OffsetDateTime restorePointInTime) {
        this.restorePointInTime = restorePointInTime;
        return this;
    }

    public OffsetDateTime sourceDatabaseDeletionDate() {
        return this.sourceDatabaseDeletionDate;
    }

    public DatabaseProperties withSourceDatabaseDeletionDate(OffsetDateTime sourceDatabaseDeletionDate) {
        this.sourceDatabaseDeletionDate = sourceDatabaseDeletionDate;
        return this;
    }

    public String recoveryServicesRecoveryPointId() {
        return this.recoveryServicesRecoveryPointId;
    }

    public DatabaseProperties withRecoveryServicesRecoveryPointId(String recoveryServicesRecoveryPointId) {
        this.recoveryServicesRecoveryPointId = recoveryServicesRecoveryPointId;
        return this;
    }

    public String longTermRetentionBackupResourceId() {
        return this.longTermRetentionBackupResourceId;
    }

    public DatabaseProperties withLongTermRetentionBackupResourceId(String longTermRetentionBackupResourceId) {
        this.longTermRetentionBackupResourceId = longTermRetentionBackupResourceId;
        return this;
    }

    public String recoverableDatabaseId() {
        return this.recoverableDatabaseId;
    }

    public DatabaseProperties withRecoverableDatabaseId(String recoverableDatabaseId) {
        this.recoverableDatabaseId = recoverableDatabaseId;
        return this;
    }

    public String restorableDroppedDatabaseId() {
        return this.restorableDroppedDatabaseId;
    }

    public DatabaseProperties withRestorableDroppedDatabaseId(String restorableDroppedDatabaseId) {
        this.restorableDroppedDatabaseId = restorableDroppedDatabaseId;
        return this;
    }

    public CatalogCollationType catalogCollation() {
        return this.catalogCollation;
    }

    public DatabaseProperties withCatalogCollation(CatalogCollationType catalogCollation) {
        this.catalogCollation = catalogCollation;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public DatabaseProperties withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public DatabaseLicenseType licenseType() {
        return this.licenseType;
    }

    public DatabaseProperties withLicenseType(DatabaseLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public Long maxLogSizeBytes() {
        return this.maxLogSizeBytes;
    }

    public OffsetDateTime earliestRestoreDate() {
        return this.earliestRestoreDate;
    }

    public DatabaseReadScale readScale() {
        return this.readScale;
    }

    public DatabaseProperties withReadScale(DatabaseReadScale readScale) {
        this.readScale = readScale;
        return this;
    }

    public Integer highAvailabilityReplicaCount() {
        return this.highAvailabilityReplicaCount;
    }

    public DatabaseProperties withHighAvailabilityReplicaCount(Integer highAvailabilityReplicaCount) {
        this.highAvailabilityReplicaCount = highAvailabilityReplicaCount;
        return this;
    }

    public SecondaryType secondaryType() {
        return this.secondaryType;
    }

    public DatabaseProperties withSecondaryType(SecondaryType secondaryType) {
        this.secondaryType = secondaryType;
        return this;
    }

    public Sku currentSku() {
        return this.currentSku;
    }

    public Integer autoPauseDelay() {
        return this.autoPauseDelay;
    }

    public DatabaseProperties withAutoPauseDelay(Integer autoPauseDelay) {
        this.autoPauseDelay = autoPauseDelay;
        return this;
    }

    public BackupStorageRedundancy currentBackupStorageRedundancy() {
        return this.currentBackupStorageRedundancy;
    }

    public BackupStorageRedundancy requestedBackupStorageRedundancy() {
        return this.requestedBackupStorageRedundancy;
    }

    public DatabaseProperties withRequestedBackupStorageRedundancy(BackupStorageRedundancy requestedBackupStorageRedundancy) {
        this.requestedBackupStorageRedundancy = requestedBackupStorageRedundancy;
        return this;
    }

    public Double minCapacity() {
        return this.minCapacity;
    }

    public DatabaseProperties withMinCapacity(Double minCapacity) {
        this.minCapacity = minCapacity;
        return this;
    }

    public OffsetDateTime pausedDate() {
        return this.pausedDate;
    }

    public OffsetDateTime resumedDate() {
        return this.resumedDate;
    }

    public String maintenanceConfigurationId() {
        return this.maintenanceConfigurationId;
    }

    public DatabaseProperties withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        this.maintenanceConfigurationId = maintenanceConfigurationId;
        return this;
    }

    public Boolean isLedgerOn() {
        return this.isLedgerOn;
    }

    public DatabaseProperties withIsLedgerOn(Boolean isLedgerOn) {
        this.isLedgerOn = isLedgerOn;
        return this;
    }

    public Boolean isInfraEncryptionEnabled() {
        return this.isInfraEncryptionEnabled;
    }

    public UUID federatedClientId() {
        return this.federatedClientId;
    }

    public DatabaseProperties withFederatedClientId(UUID federatedClientId) {
        this.federatedClientId = federatedClientId;
        return this;
    }

    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    public DatabaseProperties withSourceResourceId(String sourceResourceId) {
        this.sourceResourceId = sourceResourceId;
        return this;
    }

    public void validate() {
        if (this.currentSku() != null) {
            this.currentSku().validate();
        }
    }
}

