/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.sql.fluent.models.ManagedInstanceInner;
import com.azure.resourcemanager.sql.fluent.models.OutboundEnvironmentEndpointInner;
import com.azure.resourcemanager.sql.fluent.models.TopQueriesInner;
import com.azure.resourcemanager.sql.models.AggregationFunctionType;
import com.azure.resourcemanager.sql.models.ManagedInstanceUpdate;
import com.azure.resourcemanager.sql.models.MetricType;
import com.azure.resourcemanager.sql.models.QueryTimeGrainType;
import com.azure.resourcemanager.sql.models.ReplicaType;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ManagedInstancesClient
extends InnerSupportsGet<ManagedInstanceInner>,
InnerSupportsListing<ManagedInstanceInner>,
InnerSupportsDelete<Void> {
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ManagedInstanceInner> listAsync(String var1);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ManagedInstanceInner> listAsync();

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedInstanceInner> list();

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedInstanceInner> list(String var1, Context var2);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ManagedInstanceInner> listByInstancePoolAsync(String var1, String var2, String var3);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ManagedInstanceInner> listByInstancePoolAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedInstanceInner> listByInstancePool(String var1, String var2);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedInstanceInner> listByInstancePool(String var1, String var2, String var3, Context var4);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ManagedInstanceInner> listByResourceGroupAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ManagedInstanceInner> listByResourceGroupAsync(String var1);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedInstanceInner> listByResourceGroup(String var1);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedInstanceInner> listByResourceGroup(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ManagedInstanceInner>> getByResourceGroupWithResponseAsync(String var1, String var2, String var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ManagedInstanceInner> getByResourceGroupAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ManagedInstanceInner> getByResourceGroupWithResponse(String var1, String var2, String var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedInstanceInner getByResourceGroup(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String var1, String var2, ManagedInstanceInner var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ManagedInstanceInner>, ManagedInstanceInner> beginCreateOrUpdateAsync(String var1, String var2, ManagedInstanceInner var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedInstanceInner>, ManagedInstanceInner> beginCreateOrUpdate(String var1, String var2, ManagedInstanceInner var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedInstanceInner>, ManagedInstanceInner> beginCreateOrUpdate(String var1, String var2, ManagedInstanceInner var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ManagedInstanceInner> createOrUpdateAsync(String var1, String var2, ManagedInstanceInner var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedInstanceInner createOrUpdate(String var1, String var2, ManagedInstanceInner var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedInstanceInner createOrUpdate(String var1, String var2, ManagedInstanceInner var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String var1, String var2, ManagedInstanceUpdate var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ManagedInstanceInner>, ManagedInstanceInner> beginUpdateAsync(String var1, String var2, ManagedInstanceUpdate var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedInstanceInner>, ManagedInstanceInner> beginUpdate(String var1, String var2, ManagedInstanceUpdate var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedInstanceInner>, ManagedInstanceInner> beginUpdate(String var1, String var2, ManagedInstanceUpdate var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ManagedInstanceInner> updateAsync(String var1, String var2, ManagedInstanceUpdate var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedInstanceInner update(String var1, String var2, ManagedInstanceUpdate var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedInstanceInner update(String var1, String var2, ManagedInstanceUpdate var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> failoverWithResponseAsync(String var1, String var2, ReplicaType var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginFailoverAsync(String var1, String var2, ReplicaType var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginFailoverAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginFailover(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginFailover(String var1, String var2, ReplicaType var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> failoverAsync(String var1, String var2, ReplicaType var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> failoverAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void failover(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void failover(String var1, String var2, ReplicaType var3, Context var4);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<OutboundEnvironmentEndpointInner> listOutboundNetworkDependenciesByManagedInstanceAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OutboundEnvironmentEndpointInner> listOutboundNetworkDependenciesByManagedInstance(String var1, String var2);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OutboundEnvironmentEndpointInner> listOutboundNetworkDependenciesByManagedInstance(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginStartAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStart(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStart(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void start(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void start(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> stopWithResponseAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginStopAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStop(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStop(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stop(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stop(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TopQueriesInner> listByManagedInstanceAsync(String var1, String var2, Integer var3, String var4, String var5, String var6, QueryTimeGrainType var7, AggregationFunctionType var8, MetricType var9);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TopQueriesInner> listByManagedInstanceAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TopQueriesInner> listByManagedInstance(String var1, String var2);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TopQueriesInner> listByManagedInstance(String var1, String var2, Integer var3, String var4, String var5, String var6, QueryTimeGrainType var7, AggregationFunctionType var8, MetricType var9, Context var10);
}

