/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.fluent.models.RecommendedActionInner;
import com.azure.resourcemanager.sql.models.AdvisorStatus;
import com.azure.resourcemanager.sql.models.AutoExecuteStatus;
import com.azure.resourcemanager.sql.models.AutoExecuteStatusInheritedFrom;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class AdvisorProperties {
    @JsonProperty(value="advisorStatus", access=JsonProperty.Access.WRITE_ONLY)
    private AdvisorStatus advisorStatus;
    @JsonProperty(value="autoExecuteStatus", required=true)
    private AutoExecuteStatus autoExecuteStatus;
    @JsonProperty(value="autoExecuteStatusInheritedFrom", access=JsonProperty.Access.WRITE_ONLY)
    private AutoExecuteStatusInheritedFrom autoExecuteStatusInheritedFrom;
    @JsonProperty(value="recommendationsStatus", access=JsonProperty.Access.WRITE_ONLY)
    private String recommendationsStatus;
    @JsonProperty(value="lastChecked", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastChecked;
    @JsonProperty(value="recommendedActions", access=JsonProperty.Access.WRITE_ONLY)
    private List<RecommendedActionInner> recommendedActions;
    private static final ClientLogger LOGGER = new ClientLogger(AdvisorProperties.class);

    public AdvisorStatus advisorStatus() {
        return this.advisorStatus;
    }

    public AutoExecuteStatus autoExecuteStatus() {
        return this.autoExecuteStatus;
    }

    public AdvisorProperties withAutoExecuteStatus(AutoExecuteStatus autoExecuteStatus) {
        this.autoExecuteStatus = autoExecuteStatus;
        return this;
    }

    public AutoExecuteStatusInheritedFrom autoExecuteStatusInheritedFrom() {
        return this.autoExecuteStatusInheritedFrom;
    }

    public String recommendationsStatus() {
        return this.recommendationsStatus;
    }

    public OffsetDateTime lastChecked() {
        return this.lastChecked;
    }

    public List<RecommendedActionInner> recommendedActions() {
        return this.recommendedActions;
    }

    public void validate() {
        if (this.autoExecuteStatus() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property autoExecuteStatus in model AdvisorProperties"));
        }
        if (this.recommendedActions() != null) {
            this.recommendedActions().forEach(e -> e.validate());
        }
    }
}

