/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.FailoverGroupDatabasesSecondaryType;
import com.azure.resourcemanager.sql.models.FailoverGroupReadOnlyEndpoint;
import com.azure.resourcemanager.sql.models.FailoverGroupReadWriteEndpoint;
import com.azure.resourcemanager.sql.models.FailoverGroupReplicationRole;
import com.azure.resourcemanager.sql.models.PartnerInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class FailoverGroupProperties {
    @JsonProperty(value="readWriteEndpoint", required=true)
    private FailoverGroupReadWriteEndpoint readWriteEndpoint;
    @JsonProperty(value="readOnlyEndpoint")
    private FailoverGroupReadOnlyEndpoint readOnlyEndpoint;
    @JsonProperty(value="replicationRole", access=JsonProperty.Access.WRITE_ONLY)
    private FailoverGroupReplicationRole replicationRole;
    @JsonProperty(value="replicationState", access=JsonProperty.Access.WRITE_ONLY)
    private String replicationState;
    @JsonProperty(value="partnerServers", required=true)
    private List<PartnerInfo> partnerServers;
    @JsonProperty(value="databases")
    private List<String> databases;
    @JsonProperty(value="secondaryType")
    private FailoverGroupDatabasesSecondaryType secondaryType;
    private static final ClientLogger LOGGER = new ClientLogger(FailoverGroupProperties.class);

    public FailoverGroupReadWriteEndpoint readWriteEndpoint() {
        return this.readWriteEndpoint;
    }

    public FailoverGroupProperties withReadWriteEndpoint(FailoverGroupReadWriteEndpoint readWriteEndpoint) {
        this.readWriteEndpoint = readWriteEndpoint;
        return this;
    }

    public FailoverGroupReadOnlyEndpoint readOnlyEndpoint() {
        return this.readOnlyEndpoint;
    }

    public FailoverGroupProperties withReadOnlyEndpoint(FailoverGroupReadOnlyEndpoint readOnlyEndpoint) {
        this.readOnlyEndpoint = readOnlyEndpoint;
        return this;
    }

    public FailoverGroupReplicationRole replicationRole() {
        return this.replicationRole;
    }

    public String replicationState() {
        return this.replicationState;
    }

    public List<PartnerInfo> partnerServers() {
        return this.partnerServers;
    }

    public FailoverGroupProperties withPartnerServers(List<PartnerInfo> partnerServers) {
        this.partnerServers = partnerServers;
        return this;
    }

    public List<String> databases() {
        return this.databases;
    }

    public FailoverGroupProperties withDatabases(List<String> databases) {
        this.databases = databases;
        return this;
    }

    public FailoverGroupDatabasesSecondaryType secondaryType() {
        return this.secondaryType;
    }

    public FailoverGroupProperties withSecondaryType(FailoverGroupDatabasesSecondaryType secondaryType) {
        this.secondaryType = secondaryType;
        return this;
    }

    public void validate() {
        if (this.readWriteEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property readWriteEndpoint in model FailoverGroupProperties"));
        }
        this.readWriteEndpoint().validate();
        if (this.readOnlyEndpoint() != null) {
            this.readOnlyEndpoint().validate();
        }
        if (this.partnerServers() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property partnerServers in model FailoverGroupProperties"));
        }
        this.partnerServers().forEach(e -> e.validate());
    }
}

