/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.JobStepAction;
import com.azure.resourcemanager.sql.models.JobStepExecutionOptions;
import com.azure.resourcemanager.sql.models.JobStepOutput;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class JobStepProperties {
    @JsonProperty(value="stepId")
    private Integer stepId;
    @JsonProperty(value="targetGroup", required=true)
    private String targetGroup;
    @JsonProperty(value="credential", required=true)
    private String credential;
    @JsonProperty(value="action", required=true)
    private JobStepAction action;
    @JsonProperty(value="output")
    private JobStepOutput output;
    @JsonProperty(value="executionOptions")
    private JobStepExecutionOptions executionOptions;
    private static final ClientLogger LOGGER = new ClientLogger(JobStepProperties.class);

    public Integer stepId() {
        return this.stepId;
    }

    public JobStepProperties withStepId(Integer stepId) {
        this.stepId = stepId;
        return this;
    }

    public String targetGroup() {
        return this.targetGroup;
    }

    public JobStepProperties withTargetGroup(String targetGroup) {
        this.targetGroup = targetGroup;
        return this;
    }

    public String credential() {
        return this.credential;
    }

    public JobStepProperties withCredential(String credential) {
        this.credential = credential;
        return this;
    }

    public JobStepAction action() {
        return this.action;
    }

    public JobStepProperties withAction(JobStepAction action) {
        this.action = action;
        return this;
    }

    public JobStepOutput output() {
        return this.output;
    }

    public JobStepProperties withOutput(JobStepOutput output) {
        this.output = output;
        return this;
    }

    public JobStepExecutionOptions executionOptions() {
        return this.executionOptions;
    }

    public JobStepProperties withExecutionOptions(JobStepExecutionOptions executionOptions) {
        this.executionOptions = executionOptions;
        return this;
    }

    public void validate() {
        if (this.targetGroup() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetGroup in model JobStepProperties"));
        }
        if (this.credential() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property credential in model JobStepProperties"));
        }
        if (this.action() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property action in model JobStepProperties"));
        }
        this.action().validate();
        if (this.output() != null) {
            this.output().validate();
        }
        if (this.executionOptions() != null) {
            this.executionOptions().validate();
        }
    }
}

