/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.ServerKeyType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class ManagedInstanceKeyProperties {
    @JsonProperty(value="serverKeyType", required=true)
    private ServerKeyType serverKeyType;
    @JsonProperty(value="uri")
    private String uri;
    @JsonProperty(value="thumbprint", access=JsonProperty.Access.WRITE_ONLY)
    private String thumbprint;
    @JsonProperty(value="creationDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationDate;
    @JsonProperty(value="autoRotationEnabled", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean autoRotationEnabled;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedInstanceKeyProperties.class);

    public ServerKeyType serverKeyType() {
        return this.serverKeyType;
    }

    public ManagedInstanceKeyProperties withServerKeyType(ServerKeyType serverKeyType) {
        this.serverKeyType = serverKeyType;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public ManagedInstanceKeyProperties withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public Boolean autoRotationEnabled() {
        return this.autoRotationEnabled;
    }

    public void validate() {
        if (this.serverKeyType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serverKeyType in model ManagedInstanceKeyProperties"));
        }
    }
}

