/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class SecurityAlertsPolicyProperties {
    @JsonProperty(value="state", required=true)
    private SecurityAlertPolicyState state;
    @JsonProperty(value="disabledAlerts")
    private List<String> disabledAlerts;
    @JsonProperty(value="emailAddresses")
    private List<String> emailAddresses;
    @JsonProperty(value="emailAccountAdmins")
    private Boolean emailAccountAdmins;
    @JsonProperty(value="storageEndpoint")
    private String storageEndpoint;
    @JsonProperty(value="storageAccountAccessKey")
    private String storageAccountAccessKey;
    @JsonProperty(value="retentionDays")
    private Integer retentionDays;
    @JsonProperty(value="creationTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationTime;
    private static final ClientLogger LOGGER = new ClientLogger(SecurityAlertsPolicyProperties.class);

    public SecurityAlertPolicyState state() {
        return this.state;
    }

    public SecurityAlertsPolicyProperties withState(SecurityAlertPolicyState state) {
        this.state = state;
        return this;
    }

    public List<String> disabledAlerts() {
        return this.disabledAlerts;
    }

    public SecurityAlertsPolicyProperties withDisabledAlerts(List<String> disabledAlerts) {
        this.disabledAlerts = disabledAlerts;
        return this;
    }

    public List<String> emailAddresses() {
        return this.emailAddresses;
    }

    public SecurityAlertsPolicyProperties withEmailAddresses(List<String> emailAddresses) {
        this.emailAddresses = emailAddresses;
        return this;
    }

    public Boolean emailAccountAdmins() {
        return this.emailAccountAdmins;
    }

    public SecurityAlertsPolicyProperties withEmailAccountAdmins(Boolean emailAccountAdmins) {
        this.emailAccountAdmins = emailAccountAdmins;
        return this;
    }

    public String storageEndpoint() {
        return this.storageEndpoint;
    }

    public SecurityAlertsPolicyProperties withStorageEndpoint(String storageEndpoint) {
        this.storageEndpoint = storageEndpoint;
        return this;
    }

    public String storageAccountAccessKey() {
        return this.storageAccountAccessKey;
    }

    public SecurityAlertsPolicyProperties withStorageAccountAccessKey(String storageAccountAccessKey) {
        this.storageAccountAccessKey = storageAccountAccessKey;
        return this;
    }

    public Integer retentionDays() {
        return this.retentionDays;
    }

    public SecurityAlertsPolicyProperties withRetentionDays(Integer retentionDays) {
        this.retentionDays = retentionDays;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public void validate() {
        if (this.state() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property state in model SecurityAlertsPolicyProperties"));
        }
    }
}

