/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.resourcemanager.sql.models.ExternalGovernanceStatus;
import com.azure.resourcemanager.sql.models.MinimalTlsVersion;
import com.azure.resourcemanager.sql.models.ServerExternalAdministrator;
import com.azure.resourcemanager.sql.models.ServerNetworkAccessFlag;
import com.azure.resourcemanager.sql.models.ServerPrivateEndpointConnection;
import com.azure.resourcemanager.sql.models.ServerWorkspaceFeature;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.UUID;

public final class ServerProperties {
    @JsonProperty(value="administratorLogin")
    private String administratorLogin;
    @JsonProperty(value="administratorLoginPassword")
    private String administratorLoginPassword;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="state", access=JsonProperty.Access.WRITE_ONLY)
    private String state;
    @JsonProperty(value="fullyQualifiedDomainName", access=JsonProperty.Access.WRITE_ONLY)
    private String fullyQualifiedDomainName;
    @JsonProperty(value="privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<ServerPrivateEndpointConnection> privateEndpointConnections;
    @JsonProperty(value="minimalTlsVersion")
    private MinimalTlsVersion minimalTlsVersion;
    @JsonProperty(value="publicNetworkAccess")
    private ServerNetworkAccessFlag publicNetworkAccess;
    @JsonProperty(value="workspaceFeature", access=JsonProperty.Access.WRITE_ONLY)
    private ServerWorkspaceFeature workspaceFeature;
    @JsonProperty(value="primaryUserAssignedIdentityId")
    private String primaryUserAssignedIdentityId;
    @JsonProperty(value="federatedClientId")
    private UUID federatedClientId;
    @JsonProperty(value="keyId")
    private String keyId;
    @JsonProperty(value="administrators")
    private ServerExternalAdministrator administrators;
    @JsonProperty(value="restrictOutboundNetworkAccess")
    private ServerNetworkAccessFlag restrictOutboundNetworkAccess;
    @JsonProperty(value="isIPv6Enabled")
    private ServerNetworkAccessFlag isIPv6Enabled;
    @JsonProperty(value="externalGovernanceStatus", access=JsonProperty.Access.WRITE_ONLY)
    private ExternalGovernanceStatus externalGovernanceStatus;

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ServerProperties withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ServerProperties withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public String version() {
        return this.version;
    }

    public ServerProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    public String state() {
        return this.state;
    }

    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public List<ServerPrivateEndpointConnection> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public MinimalTlsVersion minimalTlsVersion() {
        return this.minimalTlsVersion;
    }

    public ServerProperties withMinimalTlsVersion(MinimalTlsVersion minimalTlsVersion) {
        this.minimalTlsVersion = minimalTlsVersion;
        return this;
    }

    public ServerNetworkAccessFlag publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ServerProperties withPublicNetworkAccess(ServerNetworkAccessFlag publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public ServerWorkspaceFeature workspaceFeature() {
        return this.workspaceFeature;
    }

    public String primaryUserAssignedIdentityId() {
        return this.primaryUserAssignedIdentityId;
    }

    public ServerProperties withPrimaryUserAssignedIdentityId(String primaryUserAssignedIdentityId) {
        this.primaryUserAssignedIdentityId = primaryUserAssignedIdentityId;
        return this;
    }

    public UUID federatedClientId() {
        return this.federatedClientId;
    }

    public ServerProperties withFederatedClientId(UUID federatedClientId) {
        this.federatedClientId = federatedClientId;
        return this;
    }

    public String keyId() {
        return this.keyId;
    }

    public ServerProperties withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public ServerExternalAdministrator administrators() {
        return this.administrators;
    }

    public ServerProperties withAdministrators(ServerExternalAdministrator administrators) {
        this.administrators = administrators;
        return this;
    }

    public ServerNetworkAccessFlag restrictOutboundNetworkAccess() {
        return this.restrictOutboundNetworkAccess;
    }

    public ServerProperties withRestrictOutboundNetworkAccess(ServerNetworkAccessFlag restrictOutboundNetworkAccess) {
        this.restrictOutboundNetworkAccess = restrictOutboundNetworkAccess;
        return this;
    }

    public ServerNetworkAccessFlag isIPv6Enabled() {
        return this.isIPv6Enabled;
    }

    public ServerProperties withIsIPv6Enabled(ServerNetworkAccessFlag isIPv6Enabled) {
        this.isIPv6Enabled = isIPv6Enabled;
        return this;
    }

    public ExternalGovernanceStatus externalGovernanceStatus() {
        return this.externalGovernanceStatus;
    }

    public void validate() {
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.administrators() != null) {
            this.administrators().validate();
        }
    }
}

