/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.DatabaseColumnsClient;
import com.azure.resourcemanager.sql.fluent.models.DatabaseColumnInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.DatabaseColumnListResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class DatabaseColumnsClientImpl
implements DatabaseColumnsClient {
    private final DatabaseColumnsService service;
    private final SqlManagementClientImpl client;

    DatabaseColumnsClientImpl(SqlManagementClientImpl client) {
        this.service = (DatabaseColumnsService)RestProxy.create(DatabaseColumnsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseColumnInner>> listByDatabaseSinglePageAsync(String resourceGroupName, String serverName, String databaseName, List<String> schema, List<String> table, List<String> column, List<String> orderBy, String skiptoken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        ArrayList schemaConverted = schema == null ? new ArrayList() : schema.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        ArrayList tableConverted = table == null ? new ArrayList() : table.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        ArrayList columnConverted = column == null ? new ArrayList() : column.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        ArrayList orderByConverted = orderBy == null ? new ArrayList() : orderBy.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return FluxUtil.withContext(context -> this.service.listByDatabase(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, schemaConverted, tableConverted, columnConverted, orderByConverted, skiptoken, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseColumnListResult)res.getValue()).value(), ((DatabaseColumnListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseColumnInner>> listByDatabaseSinglePageAsync(String resourceGroupName, String serverName, String databaseName, List<String> schema, List<String> table, List<String> column, List<String> orderBy, String skiptoken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        ArrayList<String> schemaConverted = schema == null ? new ArrayList<String>() : schema.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        ArrayList<String> tableConverted = table == null ? new ArrayList<String>() : table.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        ArrayList<String> columnConverted = column == null ? new ArrayList<String>() : column.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        ArrayList<String> orderByConverted = orderBy == null ? new ArrayList<String>() : orderBy.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        context = this.client.mergeContext(context);
        return this.service.listByDatabase(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, schemaConverted, tableConverted, columnConverted, orderByConverted, skiptoken, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseColumnListResult)res.getValue()).value(), ((DatabaseColumnListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DatabaseColumnInner> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, List<String> schema, List<String> table, List<String> column, List<String> orderBy, String skiptoken) {
        return new PagedFlux(() -> this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName, schema, table, column, orderBy, skiptoken), nextLink -> this.listByDatabaseNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DatabaseColumnInner> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName) {
        List schema = null;
        List table = null;
        List column = null;
        List orderBy = null;
        String skiptoken = null;
        return new PagedFlux(() -> this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName, schema, table, column, orderBy, skiptoken), nextLink -> this.listByDatabaseNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DatabaseColumnInner> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, List<String> schema, List<String> table, List<String> column, List<String> orderBy, String skiptoken, Context context) {
        return new PagedFlux(() -> this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName, schema, table, column, orderBy, skiptoken, context), nextLink -> this.listByDatabaseNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DatabaseColumnInner> listByDatabase(String resourceGroupName, String serverName, String databaseName) {
        List<String> schema = null;
        List<String> table = null;
        List<String> column = null;
        List<String> orderBy = null;
        String skiptoken = null;
        return new PagedIterable(this.listByDatabaseAsync(resourceGroupName, serverName, databaseName, schema, table, column, orderBy, skiptoken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DatabaseColumnInner> listByDatabase(String resourceGroupName, String serverName, String databaseName, List<String> schema, List<String> table, List<String> column, List<String> orderBy, String skiptoken, Context context) {
        return new PagedIterable(this.listByDatabaseAsync(resourceGroupName, serverName, databaseName, schema, table, column, orderBy, skiptoken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseColumnInner>> listByTableSinglePageAsync(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByTable(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, schemaName, tableName, filter, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseColumnListResult)res.getValue()).value(), ((DatabaseColumnListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseColumnInner>> listByTableSinglePageAsync(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByTable(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, schemaName, tableName, filter, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseColumnListResult)res.getValue()).value(), ((DatabaseColumnListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DatabaseColumnInner> listByTableAsync(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String filter) {
        return new PagedFlux(() -> this.listByTableSinglePageAsync(resourceGroupName, serverName, databaseName, schemaName, tableName, filter), nextLink -> this.listByTableNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DatabaseColumnInner> listByTableAsync(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName) {
        String filter = null;
        return new PagedFlux(() -> this.listByTableSinglePageAsync(resourceGroupName, serverName, databaseName, schemaName, tableName, filter), nextLink -> this.listByTableNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DatabaseColumnInner> listByTableAsync(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String filter, Context context) {
        return new PagedFlux(() -> this.listByTableSinglePageAsync(resourceGroupName, serverName, databaseName, schemaName, tableName, filter, context), nextLink -> this.listByTableNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DatabaseColumnInner> listByTable(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName) {
        String filter = null;
        return new PagedIterable(this.listByTableAsync(resourceGroupName, serverName, databaseName, schemaName, tableName, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DatabaseColumnInner> listByTable(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String filter, Context context) {
        return new PagedIterable(this.listByTableAsync(resourceGroupName, serverName, databaseName, schemaName, tableName, filter, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatabaseColumnInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String columnName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        if (columnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter columnName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, schemaName, tableName, columnName, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DatabaseColumnInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String columnName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        if (columnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter columnName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, schemaName, tableName, columnName, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatabaseColumnInner> getAsync(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String columnName) {
        return this.getWithResponseAsync(resourceGroupName, serverName, databaseName, schemaName, tableName, columnName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DatabaseColumnInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatabaseColumnInner> getWithResponse(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String columnName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, databaseName, schemaName, tableName, columnName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseColumnInner get(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String columnName) {
        return (DatabaseColumnInner)((Object)this.getWithResponse(resourceGroupName, serverName, databaseName, schemaName, tableName, columnName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseColumnInner>> listByDatabaseNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDatabaseNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseColumnListResult)res.getValue()).value(), ((DatabaseColumnListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseColumnInner>> listByDatabaseNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByDatabaseNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseColumnListResult)res.getValue()).value(), ((DatabaseColumnListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseColumnInner>> listByTableNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByTableNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseColumnListResult)res.getValue()).value(), ((DatabaseColumnListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseColumnInner>> listByTableNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByTableNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseColumnListResult)res.getValue()).value(), ((DatabaseColumnListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientD")
    public static interface DatabaseColumnsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/columns")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseColumnListResult>> listByDatabase(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @QueryParam(value="schema", multipleQueryParams=true) List<String> var5, @QueryParam(value="table", multipleQueryParams=true) List<String> var6, @QueryParam(value="column", multipleQueryParams=true) List<String> var7, @QueryParam(value="orderBy", multipleQueryParams=true) List<String> var8, @QueryParam(value="$skiptoken") String var9, @PathParam(value="subscriptionId") String var10, @QueryParam(value="api-version") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/columns")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseColumnListResult>> listByTable(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="schemaName") String var5, @PathParam(value="tableName") String var6, @QueryParam(value="$filter") String var7, @PathParam(value="subscriptionId") String var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseColumnInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="schemaName") String var5, @PathParam(value="tableName") String var6, @PathParam(value="columnName") String var7, @PathParam(value="subscriptionId") String var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseColumnListResult>> listByDatabaseNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseColumnListResult>> listByTableNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

