/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.ServerTrustGroupsClient;
import com.azure.resourcemanager.sql.fluent.models.ServerTrustGroupInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.ServerTrustGroupListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ServerTrustGroupsClientImpl
implements ServerTrustGroupsClient {
    private final ServerTrustGroupsService service;
    private final SqlManagementClientImpl client;

    ServerTrustGroupsClientImpl(SqlManagementClientImpl client) {
        this.service = (ServerTrustGroupsService)RestProxy.create(ServerTrustGroupsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ServerTrustGroupInner>> getWithResponseAsync(String resourceGroupName, String locationName, String serverTrustGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (serverTrustGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverTrustGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, locationName, serverTrustGroupName, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ServerTrustGroupInner>> getWithResponseAsync(String resourceGroupName, String locationName, String serverTrustGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (serverTrustGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverTrustGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, locationName, serverTrustGroupName, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ServerTrustGroupInner> getAsync(String resourceGroupName, String locationName, String serverTrustGroupName) {
        return this.getWithResponseAsync(resourceGroupName, locationName, serverTrustGroupName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ServerTrustGroupInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ServerTrustGroupInner> getWithResponse(String resourceGroupName, String locationName, String serverTrustGroupName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, locationName, serverTrustGroupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServerTrustGroupInner get(String resourceGroupName, String locationName, String serverTrustGroupName) {
        return (ServerTrustGroupInner)((Object)this.getWithResponse(resourceGroupName, locationName, serverTrustGroupName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String locationName, String serverTrustGroupName, ServerTrustGroupInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (serverTrustGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverTrustGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, locationName, serverTrustGroupName, this.client.getSubscriptionId(), "2020-11-01-preview", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String locationName, String serverTrustGroupName, ServerTrustGroupInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (serverTrustGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverTrustGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, locationName, serverTrustGroupName, this.client.getSubscriptionId(), "2020-11-01-preview", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ServerTrustGroupInner>, ServerTrustGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String locationName, String serverTrustGroupName, ServerTrustGroupInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, locationName, serverTrustGroupName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ServerTrustGroupInner.class), (Type)((Object)ServerTrustGroupInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ServerTrustGroupInner>, ServerTrustGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String locationName, String serverTrustGroupName, ServerTrustGroupInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, locationName, serverTrustGroupName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ServerTrustGroupInner.class), (Type)((Object)ServerTrustGroupInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ServerTrustGroupInner>, ServerTrustGroupInner> beginCreateOrUpdate(String resourceGroupName, String locationName, String serverTrustGroupName, ServerTrustGroupInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, locationName, serverTrustGroupName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ServerTrustGroupInner>, ServerTrustGroupInner> beginCreateOrUpdate(String resourceGroupName, String locationName, String serverTrustGroupName, ServerTrustGroupInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, locationName, serverTrustGroupName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ServerTrustGroupInner> createOrUpdateAsync(String resourceGroupName, String locationName, String serverTrustGroupName, ServerTrustGroupInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, locationName, serverTrustGroupName, parameters).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ServerTrustGroupInner> createOrUpdateAsync(String resourceGroupName, String locationName, String serverTrustGroupName, ServerTrustGroupInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, locationName, serverTrustGroupName, parameters, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServerTrustGroupInner createOrUpdate(String resourceGroupName, String locationName, String serverTrustGroupName, ServerTrustGroupInner parameters) {
        return (ServerTrustGroupInner)((Object)this.createOrUpdateAsync(resourceGroupName, locationName, serverTrustGroupName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServerTrustGroupInner createOrUpdate(String resourceGroupName, String locationName, String serverTrustGroupName, ServerTrustGroupInner parameters, Context context) {
        return (ServerTrustGroupInner)((Object)this.createOrUpdateAsync(resourceGroupName, locationName, serverTrustGroupName, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String locationName, String serverTrustGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (serverTrustGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverTrustGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, locationName, serverTrustGroupName, this.client.getSubscriptionId(), "2020-11-01-preview", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String locationName, String serverTrustGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (serverTrustGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverTrustGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, locationName, serverTrustGroupName, this.client.getSubscriptionId(), "2020-11-01-preview", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String locationName, String serverTrustGroupName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, locationName, serverTrustGroupName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String locationName, String serverTrustGroupName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, locationName, serverTrustGroupName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String locationName, String serverTrustGroupName) {
        return this.beginDeleteAsync(resourceGroupName, locationName, serverTrustGroupName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String locationName, String serverTrustGroupName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, locationName, serverTrustGroupName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String locationName, String serverTrustGroupName) {
        return this.beginDeleteAsync(resourceGroupName, locationName, serverTrustGroupName).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String locationName, String serverTrustGroupName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, locationName, serverTrustGroupName, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String locationName, String serverTrustGroupName) {
        this.deleteAsync(resourceGroupName, locationName, serverTrustGroupName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String locationName, String serverTrustGroupName, Context context) {
        this.deleteAsync(resourceGroupName, locationName, serverTrustGroupName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerTrustGroupInner>> listByLocationSinglePageAsync(String resourceGroupName, String locationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByLocation(this.client.getEndpoint(), resourceGroupName, locationName, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerTrustGroupListResult)res.getValue()).value(), ((ServerTrustGroupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerTrustGroupInner>> listByLocationSinglePageAsync(String resourceGroupName, String locationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByLocation(this.client.getEndpoint(), resourceGroupName, locationName, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerTrustGroupListResult)res.getValue()).value(), ((ServerTrustGroupListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ServerTrustGroupInner> listByLocationAsync(String resourceGroupName, String locationName) {
        return new PagedFlux(() -> this.listByLocationSinglePageAsync(resourceGroupName, locationName), nextLink -> this.listByLocationNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ServerTrustGroupInner> listByLocationAsync(String resourceGroupName, String locationName, Context context) {
        return new PagedFlux(() -> this.listByLocationSinglePageAsync(resourceGroupName, locationName, context), nextLink -> this.listByLocationNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ServerTrustGroupInner> listByLocation(String resourceGroupName, String locationName) {
        return new PagedIterable(this.listByLocationAsync(resourceGroupName, locationName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ServerTrustGroupInner> listByLocation(String resourceGroupName, String locationName, Context context) {
        return new PagedIterable(this.listByLocationAsync(resourceGroupName, locationName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerTrustGroupInner>> listByInstanceSinglePageAsync(String resourceGroupName, String managedInstanceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByInstance(this.client.getEndpoint(), resourceGroupName, managedInstanceName, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerTrustGroupListResult)res.getValue()).value(), ((ServerTrustGroupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerTrustGroupInner>> listByInstanceSinglePageAsync(String resourceGroupName, String managedInstanceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByInstance(this.client.getEndpoint(), resourceGroupName, managedInstanceName, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerTrustGroupListResult)res.getValue()).value(), ((ServerTrustGroupListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ServerTrustGroupInner> listByInstanceAsync(String resourceGroupName, String managedInstanceName) {
        return new PagedFlux(() -> this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName), nextLink -> this.listByInstanceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ServerTrustGroupInner> listByInstanceAsync(String resourceGroupName, String managedInstanceName, Context context) {
        return new PagedFlux(() -> this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName, context), nextLink -> this.listByInstanceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ServerTrustGroupInner> listByInstance(String resourceGroupName, String managedInstanceName) {
        return new PagedIterable(this.listByInstanceAsync(resourceGroupName, managedInstanceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ServerTrustGroupInner> listByInstance(String resourceGroupName, String managedInstanceName, Context context) {
        return new PagedIterable(this.listByInstanceAsync(resourceGroupName, managedInstanceName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerTrustGroupInner>> listByLocationNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByLocationNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerTrustGroupListResult)res.getValue()).value(), ((ServerTrustGroupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerTrustGroupInner>> listByLocationNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByLocationNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerTrustGroupListResult)res.getValue()).value(), ((ServerTrustGroupListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerTrustGroupInner>> listByInstanceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByInstanceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerTrustGroupListResult)res.getValue()).value(), ((ServerTrustGroupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerTrustGroupInner>> listByInstanceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByInstanceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerTrustGroupListResult)res.getValue()).value(), ((ServerTrustGroupListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientS")
    public static interface ServerTrustGroupsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/serverTrustGroups/{serverTrustGroupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerTrustGroupInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="locationName") String var3, @PathParam(value="serverTrustGroupName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/serverTrustGroups/{serverTrustGroupName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="locationName") String var3, @PathParam(value="serverTrustGroupName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ServerTrustGroupInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/serverTrustGroups/{serverTrustGroupName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="locationName") String var3, @PathParam(value="serverTrustGroupName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/serverTrustGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerTrustGroupListResult>> listByLocation(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="locationName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/serverTrustGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerTrustGroupListResult>> listByInstance(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerTrustGroupListResult>> listByLocationNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerTrustGroupListResult>> listByInstanceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

