/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.SqlVulnerabilityAssessmentBaselinesOperationsClient;
import com.azure.resourcemanager.sql.fluent.models.DatabaseSqlVulnerabilityAssessmentBaselineSetInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.BaselineName;
import com.azure.resourcemanager.sql.models.DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentName;
import reactor.core.publisher.Mono;

public final class SqlVulnerabilityAssessmentBaselinesOperationsClientImpl
implements SqlVulnerabilityAssessmentBaselinesOperationsClient {
    private final SqlVulnerabilityAssessmentBaselinesOperationsService service;
    private final SqlManagementClientImpl client;

    SqlVulnerabilityAssessmentBaselinesOperationsClientImpl(SqlManagementClientImpl client) {
        this.service = (SqlVulnerabilityAssessmentBaselinesOperationsService)RestProxy.create(SqlVulnerabilityAssessmentBaselinesOperationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatabaseSqlVulnerabilityAssessmentBaselineSetInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName, DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String systemDatabaseName = "master";
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, "master", this.client.getSubscriptionId(), "2022-11-01-preview", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DatabaseSqlVulnerabilityAssessmentBaselineSetInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName, DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String systemDatabaseName = "master";
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, "master", this.client.getSubscriptionId(), "2022-11-01-preview", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatabaseSqlVulnerabilityAssessmentBaselineSetInner> createOrUpdateAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName, DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DatabaseSqlVulnerabilityAssessmentBaselineSetInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatabaseSqlVulnerabilityAssessmentBaselineSetInner> createOrUpdateWithResponse(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName, DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseSqlVulnerabilityAssessmentBaselineSetInner createOrUpdate(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName, DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput parameters) {
        return (DatabaseSqlVulnerabilityAssessmentBaselineSetInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, parameters, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientS")
    public static interface SqlVulnerabilityAssessmentBaselinesOperationsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseSqlVulnerabilityAssessmentBaselineSetInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var4, @PathParam(value="baselineName") BaselineName var5, @QueryParam(value="systemDatabaseName") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput var9, @HeaderParam(value="Accept") String var10, Context var11);
    }
}

