/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.resourcemanager.sql.fluent.models.InstancePoolProperties;
import com.azure.resourcemanager.sql.models.InstancePoolLicenseType;
import com.azure.resourcemanager.sql.models.Sku;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class InstancePoolUpdate {
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="properties")
    private InstancePoolProperties innerProperties;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    public Sku sku() {
        return this.sku;
    }

    public InstancePoolUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    private InstancePoolProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public InstancePoolUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String subnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetId();
    }

    public InstancePoolUpdate withSubnetId(String subnetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InstancePoolProperties();
        }
        this.innerProperties().withSubnetId(subnetId);
        return this;
    }

    public Integer vCores() {
        return this.innerProperties() == null ? null : Integer.valueOf(this.innerProperties().vCores());
    }

    public InstancePoolUpdate withVCores(Integer vCores) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InstancePoolProperties();
        }
        this.innerProperties().withVCores(vCores);
        return this;
    }

    public InstancePoolLicenseType licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    public InstancePoolUpdate withLicenseType(InstancePoolLicenseType licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InstancePoolProperties();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    public String dnsZone() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsZone();
    }

    public String maintenanceConfigurationId() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceConfigurationId();
    }

    public InstancePoolUpdate withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InstancePoolProperties();
        }
        this.innerProperties().withMaintenanceConfigurationId(maintenanceConfigurationId);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

