/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.DatabaseIdentityType;
import com.azure.resourcemanager.sql.models.DatabaseUserIdentity;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

public final class DatabaseIdentity
implements JsonSerializable<DatabaseIdentity> {
    private DatabaseIdentityType type;
    private UUID tenantId;
    private Map<String, DatabaseUserIdentity> userAssignedIdentities;

    public DatabaseIdentityType type() {
        return this.type;
    }

    public DatabaseIdentity withType(DatabaseIdentityType type) {
        this.type = type;
        return this;
    }

    public UUID tenantId() {
        return this.tenantId;
    }

    public Map<String, DatabaseUserIdentity> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public DatabaseIdentity withUserAssignedIdentities(Map<String, DatabaseUserIdentity> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DatabaseIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseIdentity)jsonReader.readObject(reader -> {
            DatabaseIdentity deserializedDatabaseIdentity = new DatabaseIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedDatabaseIdentity.type = DatabaseIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedDatabaseIdentity.tenantId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities;
                    deserializedDatabaseIdentity.userAssignedIdentities = userAssignedIdentities = reader.readMap(reader1 -> DatabaseUserIdentity.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseIdentity;
        });
    }
}

