// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.CheckNameAvailabilityReason;
import java.io.IOException;

/**
 * The result of a name availability check.
 */
@Immutable
public final class CheckNameAvailabilityResponseInner implements JsonSerializable<CheckNameAvailabilityResponseInner> {
    /*
     * The name whose availability was checked.
     */
    private String name;

    /*
     * True if the name is available, otherwise false.
     */
    private Boolean available;

    /*
     * The reason code explaining why the name is unavailable. Will be undefined if the name is available.
     */
    private CheckNameAvailabilityReason reason;

    /*
     * A message explaining why the name is unavailable. Will be undefined if the name is available.
     */
    private String message;

    /**
     * Creates an instance of CheckNameAvailabilityResponseInner class.
     */
    public CheckNameAvailabilityResponseInner() {
    }

    /**
     * Get the name property: The name whose availability was checked.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the available property: True if the name is available, otherwise false.
     * 
     * @return the available value.
     */
    public Boolean available() {
        return this.available;
    }

    /**
     * Get the reason property: The reason code explaining why the name is unavailable. Will be undefined if the name is
     * available.
     * 
     * @return the reason value.
     */
    public CheckNameAvailabilityReason reason() {
        return this.reason;
    }

    /**
     * Get the message property: A message explaining why the name is unavailable. Will be undefined if the name is
     * available.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CheckNameAvailabilityResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CheckNameAvailabilityResponseInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CheckNameAvailabilityResponseInner.
     */
    public static CheckNameAvailabilityResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CheckNameAvailabilityResponseInner deserializedCheckNameAvailabilityResponseInner
                = new CheckNameAvailabilityResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedCheckNameAvailabilityResponseInner.name = reader.getString();
                } else if ("available".equals(fieldName)) {
                    deserializedCheckNameAvailabilityResponseInner.available
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("reason".equals(fieldName)) {
                    deserializedCheckNameAvailabilityResponseInner.reason
                        = CheckNameAvailabilityReason.fromString(reader.getString());
                } else if ("message".equals(fieldName)) {
                    deserializedCheckNameAvailabilityResponseInner.message = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCheckNameAvailabilityResponseInner;
        });
    }
}
