// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ServerKeyType;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Properties for a key execution.
 */
@Fluent
public final class ManagedInstanceKeyProperties implements JsonSerializable<ManagedInstanceKeyProperties> {
    /*
     * The key type like 'ServiceManaged', 'AzureKeyVault'.
     */
    private ServerKeyType serverKeyType;

    /*
     * The URI of the key. If the ServerKeyType is AzureKeyVault, then the URI is required.
     */
    private String uri;

    /*
     * Thumbprint of the key.
     */
    private String thumbprint;

    /*
     * The key creation date.
     */
    private OffsetDateTime creationDate;

    /*
     * Key auto rotation opt-in flag. Either true or false.
     */
    private Boolean autoRotationEnabled;

    /**
     * Creates an instance of ManagedInstanceKeyProperties class.
     */
    public ManagedInstanceKeyProperties() {
    }

    /**
     * Get the serverKeyType property: The key type like 'ServiceManaged', 'AzureKeyVault'.
     * 
     * @return the serverKeyType value.
     */
    public ServerKeyType serverKeyType() {
        return this.serverKeyType;
    }

    /**
     * Set the serverKeyType property: The key type like 'ServiceManaged', 'AzureKeyVault'.
     * 
     * @param serverKeyType the serverKeyType value to set.
     * @return the ManagedInstanceKeyProperties object itself.
     */
    public ManagedInstanceKeyProperties withServerKeyType(ServerKeyType serverKeyType) {
        this.serverKeyType = serverKeyType;
        return this;
    }

    /**
     * Get the uri property: The URI of the key. If the ServerKeyType is AzureKeyVault, then the URI is required.
     * 
     * @return the uri value.
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Set the uri property: The URI of the key. If the ServerKeyType is AzureKeyVault, then the URI is required.
     * 
     * @param uri the uri value to set.
     * @return the ManagedInstanceKeyProperties object itself.
     */
    public ManagedInstanceKeyProperties withUri(String uri) {
        this.uri = uri;
        return this;
    }

    /**
     * Get the thumbprint property: Thumbprint of the key.
     * 
     * @return the thumbprint value.
     */
    public String thumbprint() {
        return this.thumbprint;
    }

    /**
     * Get the creationDate property: The key creation date.
     * 
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    /**
     * Get the autoRotationEnabled property: Key auto rotation opt-in flag. Either true or false.
     * 
     * @return the autoRotationEnabled value.
     */
    public Boolean autoRotationEnabled() {
        return this.autoRotationEnabled;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (serverKeyType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property serverKeyType in model ManagedInstanceKeyProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedInstanceKeyProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serverKeyType", this.serverKeyType == null ? null : this.serverKeyType.toString());
        jsonWriter.writeStringField("uri", this.uri);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedInstanceKeyProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedInstanceKeyProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedInstanceKeyProperties.
     */
    public static ManagedInstanceKeyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstanceKeyProperties deserializedManagedInstanceKeyProperties = new ManagedInstanceKeyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serverKeyType".equals(fieldName)) {
                    deserializedManagedInstanceKeyProperties.serverKeyType
                        = ServerKeyType.fromString(reader.getString());
                } else if ("uri".equals(fieldName)) {
                    deserializedManagedInstanceKeyProperties.uri = reader.getString();
                } else if ("thumbprint".equals(fieldName)) {
                    deserializedManagedInstanceKeyProperties.thumbprint = reader.getString();
                } else if ("creationDate".equals(fieldName)) {
                    deserializedManagedInstanceKeyProperties.creationDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("autoRotationEnabled".equals(fieldName)) {
                    deserializedManagedInstanceKeyProperties.autoRotationEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedInstanceKeyProperties;
        });
    }
}
