// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * A recoverable database resource.
 */
@Immutable
public final class RecoverableDatabaseInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private RecoverableDatabaseProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of RecoverableDatabaseInner class.
     */
    public RecoverableDatabaseInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private RecoverableDatabaseProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the edition property: The edition of the database.
     * 
     * @return the edition value.
     */
    public String edition() {
        return this.innerProperties() == null ? null : this.innerProperties().edition();
    }

    /**
     * Get the serviceLevelObjective property: The service level objective name of the database.
     * 
     * @return the serviceLevelObjective value.
     */
    public String serviceLevelObjective() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceLevelObjective();
    }

    /**
     * Get the elasticPoolName property: The elastic pool name of the database.
     * 
     * @return the elasticPoolName value.
     */
    public String elasticPoolName() {
        return this.innerProperties() == null ? null : this.innerProperties().elasticPoolName();
    }

    /**
     * Get the lastAvailableBackupDate property: The last available backup date.
     * 
     * @return the lastAvailableBackupDate value.
     */
    public OffsetDateTime lastAvailableBackupDate() {
        return this.innerProperties() == null ? null : this.innerProperties().lastAvailableBackupDate();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecoverableDatabaseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecoverableDatabaseInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RecoverableDatabaseInner.
     */
    public static RecoverableDatabaseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecoverableDatabaseInner deserializedRecoverableDatabaseInner = new RecoverableDatabaseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRecoverableDatabaseInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRecoverableDatabaseInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRecoverableDatabaseInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedRecoverableDatabaseInner.innerProperties
                        = RecoverableDatabaseProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecoverableDatabaseInner;
        });
    }
}
