// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ResourceIdentity;
import com.azure.resourcemanager.sql.models.ServerExternalAdministrator;
import com.azure.resourcemanager.sql.models.ServerNetworkAccessFlag;
import com.azure.resourcemanager.sql.models.ServerPrivateEndpointConnection;
import com.azure.resourcemanager.sql.models.ServerWorkspaceFeature;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * An Azure SQL Database server.
 */
@Fluent
public final class ServerInner extends Resource {
    /*
     * The Azure Active Directory identity of the server.
     */
    private ResourceIdentity identity;

    /*
     * Kind of sql server. This is metadata used for the Azure portal experience.
     */
    private String kind;

    /*
     * Resource properties.
     */
    private ServerProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ServerInner class.
     */
    public ServerInner() {
    }

    /**
     * Get the identity property: The Azure Active Directory identity of the server.
     * 
     * @return the identity value.
     */
    public ResourceIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The Azure Active Directory identity of the server.
     * 
     * @param identity the identity value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withIdentity(ResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the kind property: Kind of sql server. This is metadata used for the Azure portal experience.
     * 
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private ServerProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ServerInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ServerInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the administratorLogin property: Administrator username for the server. Once created it cannot be changed.
     * 
     * @return the administratorLogin value.
     */
    public String administratorLogin() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLogin();
    }

    /**
     * Set the administratorLogin property: Administrator username for the server. Once created it cannot be changed.
     * 
     * @param administratorLogin the administratorLogin value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withAdministratorLogin(String administratorLogin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministratorLogin(administratorLogin);
        return this;
    }

    /**
     * Get the administratorLoginPassword property: The administrator login password (required for server creation).
     * 
     * @return the administratorLoginPassword value.
     */
    public String administratorLoginPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLoginPassword();
    }

    /**
     * Set the administratorLoginPassword property: The administrator login password (required for server creation).
     * 
     * @param administratorLoginPassword the administratorLoginPassword value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    /**
     * Get the version property: The version of the server.
     * 
     * @return the version value.
     */
    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    /**
     * Set the version property: The version of the server.
     * 
     * @param version the version value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withVersion(String version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    /**
     * Get the state property: The state of the server.
     * 
     * @return the state value.
     */
    public String state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Get the fullyQualifiedDomainName property: The fully qualified domain name of the server.
     * 
     * @return the fullyQualifiedDomainName value.
     */
    public String fullyQualifiedDomainName() {
        return this.innerProperties() == null ? null : this.innerProperties().fullyQualifiedDomainName();
    }

    /**
     * Get the privateEndpointConnections property: List of private endpoint connections on a server.
     * 
     * @return the privateEndpointConnections value.
     */
    public List<ServerPrivateEndpointConnection> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    /**
     * Get the minimalTlsVersion property: Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'.
     * 
     * @return the minimalTlsVersion value.
     */
    public String minimalTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimalTlsVersion();
    }

    /**
     * Set the minimalTlsVersion property: Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'.
     * 
     * @param minimalTlsVersion the minimalTlsVersion value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withMinimalTlsVersion(String minimalTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Whether or not public endpoint access is allowed for this server. Value is
     * optional but if passed in, must be 'Enabled' or 'Disabled'.
     * 
     * @return the publicNetworkAccess value.
     */
    public ServerNetworkAccessFlag publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    /**
     * Set the publicNetworkAccess property: Whether or not public endpoint access is allowed for this server. Value is
     * optional but if passed in, must be 'Enabled' or 'Disabled'.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withPublicNetworkAccess(ServerNetworkAccessFlag publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    /**
     * Get the workspaceFeature property: Whether or not existing server has a workspace created and if it allows
     * connection from workspace.
     * 
     * @return the workspaceFeature value.
     */
    public ServerWorkspaceFeature workspaceFeature() {
        return this.innerProperties() == null ? null : this.innerProperties().workspaceFeature();
    }

    /**
     * Get the primaryUserAssignedIdentityId property: The resource id of a user assigned identity to be used by
     * default.
     * 
     * @return the primaryUserAssignedIdentityId value.
     */
    public String primaryUserAssignedIdentityId() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryUserAssignedIdentityId();
    }

    /**
     * Set the primaryUserAssignedIdentityId property: The resource id of a user assigned identity to be used by
     * default.
     * 
     * @param primaryUserAssignedIdentityId the primaryUserAssignedIdentityId value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withPrimaryUserAssignedIdentityId(String primaryUserAssignedIdentityId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withPrimaryUserAssignedIdentityId(primaryUserAssignedIdentityId);
        return this;
    }

    /**
     * Get the federatedClientId property: The Client id used for cross tenant CMK scenario.
     * 
     * @return the federatedClientId value.
     */
    public UUID federatedClientId() {
        return this.innerProperties() == null ? null : this.innerProperties().federatedClientId();
    }

    /**
     * Set the federatedClientId property: The Client id used for cross tenant CMK scenario.
     * 
     * @param federatedClientId the federatedClientId value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withFederatedClientId(UUID federatedClientId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withFederatedClientId(federatedClientId);
        return this;
    }

    /**
     * Get the keyId property: A CMK URI of the key to use for encryption.
     * 
     * @return the keyId value.
     */
    public String keyId() {
        return this.innerProperties() == null ? null : this.innerProperties().keyId();
    }

    /**
     * Set the keyId property: A CMK URI of the key to use for encryption.
     * 
     * @param keyId the keyId value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withKeyId(String keyId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withKeyId(keyId);
        return this;
    }

    /**
     * Get the administrators property: The Azure Active Directory administrator of the server.
     * 
     * @return the administrators value.
     */
    public ServerExternalAdministrator administrators() {
        return this.innerProperties() == null ? null : this.innerProperties().administrators();
    }

    /**
     * Set the administrators property: The Azure Active Directory administrator of the server.
     * 
     * @param administrators the administrators value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withAdministrators(ServerExternalAdministrator administrators) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministrators(administrators);
        return this;
    }

    /**
     * Get the restrictOutboundNetworkAccess property: Whether or not to restrict outbound network access for this
     * server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
     * 
     * @return the restrictOutboundNetworkAccess value.
     */
    public ServerNetworkAccessFlag restrictOutboundNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().restrictOutboundNetworkAccess();
    }

    /**
     * Set the restrictOutboundNetworkAccess property: Whether or not to restrict outbound network access for this
     * server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
     * 
     * @param restrictOutboundNetworkAccess the restrictOutboundNetworkAccess value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withRestrictOutboundNetworkAccess(ServerNetworkAccessFlag restrictOutboundNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withRestrictOutboundNetworkAccess(restrictOutboundNetworkAccess);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ServerInner.
     */
    public static ServerInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerInner deserializedServerInner = new ServerInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedServerInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedServerInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedServerInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedServerInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedServerInner.withTags(tags);
                } else if ("identity".equals(fieldName)) {
                    deserializedServerInner.identity = ResourceIdentity.fromJson(reader);
                } else if ("kind".equals(fieldName)) {
                    deserializedServerInner.kind = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedServerInner.innerProperties = ServerProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerInner;
        });
    }
}
