// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ServerExternalAdministrator;
import com.azure.resourcemanager.sql.models.ServerNetworkAccessFlag;
import com.azure.resourcemanager.sql.models.ServerPrivateEndpointConnection;
import com.azure.resourcemanager.sql.models.ServerWorkspaceFeature;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

/**
 * The properties of a server.
 */
@Fluent
public final class ServerProperties implements JsonSerializable<ServerProperties> {
    /*
     * Administrator username for the server. Once created it cannot be changed.
     */
    private String administratorLogin;

    /*
     * The administrator login password (required for server creation).
     */
    private String administratorLoginPassword;

    /*
     * The version of the server.
     */
    private String version;

    /*
     * The state of the server.
     */
    private String state;

    /*
     * The fully qualified domain name of the server.
     */
    private String fullyQualifiedDomainName;

    /*
     * List of private endpoint connections on a server
     */
    private List<ServerPrivateEndpointConnection> privateEndpointConnections;

    /*
     * Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'
     */
    private String minimalTlsVersion;

    /*
     * Whether or not public endpoint access is allowed for this server. Value is optional but if passed in, must be
     * 'Enabled' or 'Disabled'
     */
    private ServerNetworkAccessFlag publicNetworkAccess;

    /*
     * Whether or not existing server has a workspace created and if it allows connection from workspace
     */
    private ServerWorkspaceFeature workspaceFeature;

    /*
     * The resource id of a user assigned identity to be used by default.
     */
    private String primaryUserAssignedIdentityId;

    /*
     * The Client id used for cross tenant CMK scenario
     */
    private UUID federatedClientId;

    /*
     * A CMK URI of the key to use for encryption.
     */
    private String keyId;

    /*
     * The Azure Active Directory administrator of the server.
     */
    private ServerExternalAdministrator administrators;

    /*
     * Whether or not to restrict outbound network access for this server. Value is optional but if passed in, must be
     * 'Enabled' or 'Disabled'
     */
    private ServerNetworkAccessFlag restrictOutboundNetworkAccess;

    /**
     * Creates an instance of ServerProperties class.
     */
    public ServerProperties() {
    }

    /**
     * Get the administratorLogin property: Administrator username for the server. Once created it cannot be changed.
     * 
     * @return the administratorLogin value.
     */
    public String administratorLogin() {
        return this.administratorLogin;
    }

    /**
     * Set the administratorLogin property: Administrator username for the server. Once created it cannot be changed.
     * 
     * @param administratorLogin the administratorLogin value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    /**
     * Get the administratorLoginPassword property: The administrator login password (required for server creation).
     * 
     * @return the administratorLoginPassword value.
     */
    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    /**
     * Set the administratorLoginPassword property: The administrator login password (required for server creation).
     * 
     * @param administratorLoginPassword the administratorLoginPassword value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    /**
     * Get the version property: The version of the server.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: The version of the server.
     * 
     * @param version the version value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the state property: The state of the server.
     * 
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Get the fullyQualifiedDomainName property: The fully qualified domain name of the server.
     * 
     * @return the fullyQualifiedDomainName value.
     */
    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    /**
     * Get the privateEndpointConnections property: List of private endpoint connections on a server.
     * 
     * @return the privateEndpointConnections value.
     */
    public List<ServerPrivateEndpointConnection> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /**
     * Get the minimalTlsVersion property: Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'.
     * 
     * @return the minimalTlsVersion value.
     */
    public String minimalTlsVersion() {
        return this.minimalTlsVersion;
    }

    /**
     * Set the minimalTlsVersion property: Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'.
     * 
     * @param minimalTlsVersion the minimalTlsVersion value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withMinimalTlsVersion(String minimalTlsVersion) {
        this.minimalTlsVersion = minimalTlsVersion;
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Whether or not public endpoint access is allowed for this server. Value is
     * optional but if passed in, must be 'Enabled' or 'Disabled'.
     * 
     * @return the publicNetworkAccess value.
     */
    public ServerNetworkAccessFlag publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: Whether or not public endpoint access is allowed for this server. Value is
     * optional but if passed in, must be 'Enabled' or 'Disabled'.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withPublicNetworkAccess(ServerNetworkAccessFlag publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get the workspaceFeature property: Whether or not existing server has a workspace created and if it allows
     * connection from workspace.
     * 
     * @return the workspaceFeature value.
     */
    public ServerWorkspaceFeature workspaceFeature() {
        return this.workspaceFeature;
    }

    /**
     * Get the primaryUserAssignedIdentityId property: The resource id of a user assigned identity to be used by
     * default.
     * 
     * @return the primaryUserAssignedIdentityId value.
     */
    public String primaryUserAssignedIdentityId() {
        return this.primaryUserAssignedIdentityId;
    }

    /**
     * Set the primaryUserAssignedIdentityId property: The resource id of a user assigned identity to be used by
     * default.
     * 
     * @param primaryUserAssignedIdentityId the primaryUserAssignedIdentityId value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withPrimaryUserAssignedIdentityId(String primaryUserAssignedIdentityId) {
        this.primaryUserAssignedIdentityId = primaryUserAssignedIdentityId;
        return this;
    }

    /**
     * Get the federatedClientId property: The Client id used for cross tenant CMK scenario.
     * 
     * @return the federatedClientId value.
     */
    public UUID federatedClientId() {
        return this.federatedClientId;
    }

    /**
     * Set the federatedClientId property: The Client id used for cross tenant CMK scenario.
     * 
     * @param federatedClientId the federatedClientId value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withFederatedClientId(UUID federatedClientId) {
        this.federatedClientId = federatedClientId;
        return this;
    }

    /**
     * Get the keyId property: A CMK URI of the key to use for encryption.
     * 
     * @return the keyId value.
     */
    public String keyId() {
        return this.keyId;
    }

    /**
     * Set the keyId property: A CMK URI of the key to use for encryption.
     * 
     * @param keyId the keyId value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    /**
     * Get the administrators property: The Azure Active Directory administrator of the server.
     * 
     * @return the administrators value.
     */
    public ServerExternalAdministrator administrators() {
        return this.administrators;
    }

    /**
     * Set the administrators property: The Azure Active Directory administrator of the server.
     * 
     * @param administrators the administrators value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withAdministrators(ServerExternalAdministrator administrators) {
        this.administrators = administrators;
        return this;
    }

    /**
     * Get the restrictOutboundNetworkAccess property: Whether or not to restrict outbound network access for this
     * server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
     * 
     * @return the restrictOutboundNetworkAccess value.
     */
    public ServerNetworkAccessFlag restrictOutboundNetworkAccess() {
        return this.restrictOutboundNetworkAccess;
    }

    /**
     * Set the restrictOutboundNetworkAccess property: Whether or not to restrict outbound network access for this
     * server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
     * 
     * @param restrictOutboundNetworkAccess the restrictOutboundNetworkAccess value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withRestrictOutboundNetworkAccess(ServerNetworkAccessFlag restrictOutboundNetworkAccess) {
        this.restrictOutboundNetworkAccess = restrictOutboundNetworkAccess;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (privateEndpointConnections() != null) {
            privateEndpointConnections().forEach(e -> e.validate());
        }
        if (administrators() != null) {
            administrators().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("administratorLogin", this.administratorLogin);
        jsonWriter.writeStringField("administratorLoginPassword", this.administratorLoginPassword);
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeStringField("minimalTlsVersion", this.minimalTlsVersion);
        jsonWriter.writeStringField("publicNetworkAccess",
            this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeStringField("primaryUserAssignedIdentityId", this.primaryUserAssignedIdentityId);
        jsonWriter.writeStringField("federatedClientId", Objects.toString(this.federatedClientId, null));
        jsonWriter.writeStringField("keyId", this.keyId);
        jsonWriter.writeJsonField("administrators", this.administrators);
        jsonWriter.writeStringField("restrictOutboundNetworkAccess",
            this.restrictOutboundNetworkAccess == null ? null : this.restrictOutboundNetworkAccess.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServerProperties.
     */
    public static ServerProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerProperties deserializedServerProperties = new ServerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("administratorLogin".equals(fieldName)) {
                    deserializedServerProperties.administratorLogin = reader.getString();
                } else if ("administratorLoginPassword".equals(fieldName)) {
                    deserializedServerProperties.administratorLoginPassword = reader.getString();
                } else if ("version".equals(fieldName)) {
                    deserializedServerProperties.version = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedServerProperties.state = reader.getString();
                } else if ("fullyQualifiedDomainName".equals(fieldName)) {
                    deserializedServerProperties.fullyQualifiedDomainName = reader.getString();
                } else if ("privateEndpointConnections".equals(fieldName)) {
                    List<ServerPrivateEndpointConnection> privateEndpointConnections
                        = reader.readArray(reader1 -> ServerPrivateEndpointConnection.fromJson(reader1));
                    deserializedServerProperties.privateEndpointConnections = privateEndpointConnections;
                } else if ("minimalTlsVersion".equals(fieldName)) {
                    deserializedServerProperties.minimalTlsVersion = reader.getString();
                } else if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedServerProperties.publicNetworkAccess
                        = ServerNetworkAccessFlag.fromString(reader.getString());
                } else if ("workspaceFeature".equals(fieldName)) {
                    deserializedServerProperties.workspaceFeature
                        = ServerWorkspaceFeature.fromString(reader.getString());
                } else if ("primaryUserAssignedIdentityId".equals(fieldName)) {
                    deserializedServerProperties.primaryUserAssignedIdentityId = reader.getString();
                } else if ("federatedClientId".equals(fieldName)) {
                    deserializedServerProperties.federatedClientId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("keyId".equals(fieldName)) {
                    deserializedServerProperties.keyId = reader.getString();
                } else if ("administrators".equals(fieldName)) {
                    deserializedServerProperties.administrators = ServerExternalAdministrator.fromJson(reader);
                } else if ("restrictOutboundNetworkAccess".equals(fieldName)) {
                    deserializedServerProperties.restrictOutboundNetworkAccess
                        = ServerNetworkAccessFlag.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerProperties;
        });
    }
}
