// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import java.io.IOException;

/**
 * Contains the properties to perform long term retention backup copy operation.
 */
@Fluent
public final class UpdateLongTermRetentionBackupParametersProperties
    implements JsonSerializable<UpdateLongTermRetentionBackupParametersProperties> {
    /*
     * The storage redundancy type of the copied backup
     */
    private BackupStorageRedundancy requestedBackupStorageRedundancy;

    /**
     * Creates an instance of UpdateLongTermRetentionBackupParametersProperties class.
     */
    public UpdateLongTermRetentionBackupParametersProperties() {
    }

    /**
     * Get the requestedBackupStorageRedundancy property: The storage redundancy type of the copied backup.
     * 
     * @return the requestedBackupStorageRedundancy value.
     */
    public BackupStorageRedundancy requestedBackupStorageRedundancy() {
        return this.requestedBackupStorageRedundancy;
    }

    /**
     * Set the requestedBackupStorageRedundancy property: The storage redundancy type of the copied backup.
     * 
     * @param requestedBackupStorageRedundancy the requestedBackupStorageRedundancy value to set.
     * @return the UpdateLongTermRetentionBackupParametersProperties object itself.
     */
    public UpdateLongTermRetentionBackupParametersProperties
        withRequestedBackupStorageRedundancy(BackupStorageRedundancy requestedBackupStorageRedundancy) {
        this.requestedBackupStorageRedundancy = requestedBackupStorageRedundancy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("requestedBackupStorageRedundancy",
            this.requestedBackupStorageRedundancy == null ? null : this.requestedBackupStorageRedundancy.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UpdateLongTermRetentionBackupParametersProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UpdateLongTermRetentionBackupParametersProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UpdateLongTermRetentionBackupParametersProperties.
     */
    public static UpdateLongTermRetentionBackupParametersProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UpdateLongTermRetentionBackupParametersProperties deserializedUpdateLongTermRetentionBackupParametersProperties
                = new UpdateLongTermRetentionBackupParametersProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("requestedBackupStorageRedundancy".equals(fieldName)) {
                    deserializedUpdateLongTermRetentionBackupParametersProperties.requestedBackupStorageRedundancy
                        = BackupStorageRedundancy.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUpdateLongTermRetentionBackupParametersProperties;
        });
    }
}
