// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The minimum per-database performance level capability.
 */
@Fluent
public final class ElasticPoolPerDatabaseMinPerformanceLevelCapability
    implements JsonSerializable<ElasticPoolPerDatabaseMinPerformanceLevelCapability> {
    /*
     * The minimum performance level per database.
     */
    private Double limit;

    /*
     * Unit type used to measure performance level.
     */
    private PerformanceLevelUnit unit;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /**
     * Creates an instance of ElasticPoolPerDatabaseMinPerformanceLevelCapability class.
     */
    public ElasticPoolPerDatabaseMinPerformanceLevelCapability() {
    }

    /**
     * Get the limit property: The minimum performance level per database.
     * 
     * @return the limit value.
     */
    public Double limit() {
        return this.limit;
    }

    /**
     * Get the unit property: Unit type used to measure performance level.
     * 
     * @return the unit value.
     */
    public PerformanceLevelUnit unit() {
        return this.unit;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The reason for the capability not being available.
     * 
     * @param reason the reason value to set.
     * @return the ElasticPoolPerDatabaseMinPerformanceLevelCapability object itself.
     */
    public ElasticPoolPerDatabaseMinPerformanceLevelCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ElasticPoolPerDatabaseMinPerformanceLevelCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ElasticPoolPerDatabaseMinPerformanceLevelCapability if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ElasticPoolPerDatabaseMinPerformanceLevelCapability.
     */
    public static ElasticPoolPerDatabaseMinPerformanceLevelCapability fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ElasticPoolPerDatabaseMinPerformanceLevelCapability deserializedElasticPoolPerDatabaseMinPerformanceLevelCapability
                = new ElasticPoolPerDatabaseMinPerformanceLevelCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("limit".equals(fieldName)) {
                    deserializedElasticPoolPerDatabaseMinPerformanceLevelCapability.limit
                        = reader.getNullable(JsonReader::getDouble);
                } else if ("unit".equals(fieldName)) {
                    deserializedElasticPoolPerDatabaseMinPerformanceLevelCapability.unit
                        = PerformanceLevelUnit.fromString(reader.getString());
                } else if ("status".equals(fieldName)) {
                    deserializedElasticPoolPerDatabaseMinPerformanceLevelCapability.status
                        = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedElasticPoolPerDatabaseMinPerformanceLevelCapability.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedElasticPoolPerDatabaseMinPerformanceLevelCapability;
        });
    }
}
