// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A list of recommended sensitivity label update operations.
 */
@Fluent
public final class RecommendedSensitivityLabelUpdateList
    implements JsonSerializable<RecommendedSensitivityLabelUpdateList> {
    /*
     * The operations property.
     */
    private List<RecommendedSensitivityLabelUpdate> operations;

    /**
     * Creates an instance of RecommendedSensitivityLabelUpdateList class.
     */
    public RecommendedSensitivityLabelUpdateList() {
    }

    /**
     * Get the operations property: The operations property.
     * 
     * @return the operations value.
     */
    public List<RecommendedSensitivityLabelUpdate> operations() {
        return this.operations;
    }

    /**
     * Set the operations property: The operations property.
     * 
     * @param operations the operations value to set.
     * @return the RecommendedSensitivityLabelUpdateList object itself.
     */
    public RecommendedSensitivityLabelUpdateList withOperations(List<RecommendedSensitivityLabelUpdate> operations) {
        this.operations = operations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (operations() != null) {
            operations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("operations", this.operations, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecommendedSensitivityLabelUpdateList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecommendedSensitivityLabelUpdateList if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RecommendedSensitivityLabelUpdateList.
     */
    public static RecommendedSensitivityLabelUpdateList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecommendedSensitivityLabelUpdateList deserializedRecommendedSensitivityLabelUpdateList
                = new RecommendedSensitivityLabelUpdateList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("operations".equals(fieldName)) {
                    List<RecommendedSensitivityLabelUpdate> operations
                        = reader.readArray(reader1 -> RecommendedSensitivityLabelUpdate.fromJson(reader1));
                    deserializedRecommendedSensitivityLabelUpdateList.operations = operations;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecommendedSensitivityLabelUpdateList;
        });
    }
}
