// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of a vulnerability assessment scan error.
 */
@Immutable
public final class VulnerabilityAssessmentScanError implements JsonSerializable<VulnerabilityAssessmentScanError> {
    /*
     * The error code.
     */
    private String code;

    /*
     * The error message.
     */
    private String message;

    /**
     * Creates an instance of VulnerabilityAssessmentScanError class.
     */
    public VulnerabilityAssessmentScanError() {
    }

    /**
     * Get the code property: The error code.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Get the message property: The error message.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VulnerabilityAssessmentScanError from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VulnerabilityAssessmentScanError if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VulnerabilityAssessmentScanError.
     */
    public static VulnerabilityAssessmentScanError fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VulnerabilityAssessmentScanError deserializedVulnerabilityAssessmentScanError
                = new VulnerabilityAssessmentScanError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanError.code = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanError.message = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVulnerabilityAssessmentScanError;
        });
    }
}
