// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of a database usage.
 */
@Immutable
public final class DatabaseUsageProperties implements JsonSerializable<DatabaseUsageProperties> {
    /*
     * User-readable name of the metric.
     */
    private String displayName;

    /*
     * Current value of the metric.
     */
    private Double currentValue;

    /*
     * Boundary value of the metric.
     */
    private Double limit;

    /*
     * Unit of the metric.
     */
    private String unit;

    /**
     * Creates an instance of DatabaseUsageProperties class.
     */
    public DatabaseUsageProperties() {
    }

    /**
     * Get the displayName property: User-readable name of the metric.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Get the currentValue property: Current value of the metric.
     * 
     * @return the currentValue value.
     */
    public Double currentValue() {
        return this.currentValue;
    }

    /**
     * Get the limit property: Boundary value of the metric.
     * 
     * @return the limit value.
     */
    public Double limit() {
        return this.limit;
    }

    /**
     * Get the unit property: Unit of the metric.
     * 
     * @return the unit value.
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseUsageProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseUsageProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DatabaseUsageProperties.
     */
    public static DatabaseUsageProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseUsageProperties deserializedDatabaseUsageProperties = new DatabaseUsageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("displayName".equals(fieldName)) {
                    deserializedDatabaseUsageProperties.displayName = reader.getString();
                } else if ("currentValue".equals(fieldName)) {
                    deserializedDatabaseUsageProperties.currentValue = reader.getNullable(JsonReader::getDouble);
                } else if ("limit".equals(fieldName)) {
                    deserializedDatabaseUsageProperties.limit = reader.getNullable(JsonReader::getDouble);
                } else if ("unit".equals(fieldName)) {
                    deserializedDatabaseUsageProperties.unit = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseUsageProperties;
        });
    }
}
