// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A server DNS alias.
 */
@Immutable
public final class ServerDnsAliasInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private ServerDnsAliasProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ServerDnsAliasInner class.
     */
    public ServerDnsAliasInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private ServerDnsAliasProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the azureDnsRecord property: The fully qualified DNS record for alias.
     * 
     * @return the azureDnsRecord value.
     */
    public String azureDnsRecord() {
        return this.innerProperties() == null ? null : this.innerProperties().azureDnsRecord();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerDnsAliasInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerDnsAliasInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ServerDnsAliasInner.
     */
    public static ServerDnsAliasInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerDnsAliasInner deserializedServerDnsAliasInner = new ServerDnsAliasInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedServerDnsAliasInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedServerDnsAliasInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedServerDnsAliasInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedServerDnsAliasInner.innerProperties = ServerDnsAliasProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerDnsAliasInner;
        });
    }
}
