// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ServerKeyType;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Properties for a server key execution.
 */
@Fluent
public final class ServerKeyProperties implements JsonSerializable<ServerKeyProperties> {
    /*
     * Subregion of the server key.
     */
    private String subregion;

    /*
     * The server key type like 'ServiceManaged', 'AzureKeyVault'.
     */
    private ServerKeyType serverKeyType;

    /*
     * The URI of the server key. If the ServerKeyType is AzureKeyVault, then the URI is required. The AKV URI is
     * required to be in this format: 'https://YourVaultName.vault.azure.net/keys/YourKeyName/YourKeyVersion'
     */
    private String uri;

    /*
     * Thumbprint of the server key.
     */
    private String thumbprint;

    /*
     * The server key creation date.
     */
    private OffsetDateTime creationDate;

    /*
     * Key auto rotation opt-in flag. Either true or false.
     */
    private Boolean autoRotationEnabled;

    /**
     * Creates an instance of ServerKeyProperties class.
     */
    public ServerKeyProperties() {
    }

    /**
     * Get the subregion property: Subregion of the server key.
     * 
     * @return the subregion value.
     */
    public String subregion() {
        return this.subregion;
    }

    /**
     * Get the serverKeyType property: The server key type like 'ServiceManaged', 'AzureKeyVault'.
     * 
     * @return the serverKeyType value.
     */
    public ServerKeyType serverKeyType() {
        return this.serverKeyType;
    }

    /**
     * Set the serverKeyType property: The server key type like 'ServiceManaged', 'AzureKeyVault'.
     * 
     * @param serverKeyType the serverKeyType value to set.
     * @return the ServerKeyProperties object itself.
     */
    public ServerKeyProperties withServerKeyType(ServerKeyType serverKeyType) {
        this.serverKeyType = serverKeyType;
        return this;
    }

    /**
     * Get the uri property: The URI of the server key. If the ServerKeyType is AzureKeyVault, then the URI is required.
     * The AKV URI is required to be in this format:
     * 'https://YourVaultName.vault.azure.net/keys/YourKeyName/YourKeyVersion'.
     * 
     * @return the uri value.
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Set the uri property: The URI of the server key. If the ServerKeyType is AzureKeyVault, then the URI is required.
     * The AKV URI is required to be in this format:
     * 'https://YourVaultName.vault.azure.net/keys/YourKeyName/YourKeyVersion'.
     * 
     * @param uri the uri value to set.
     * @return the ServerKeyProperties object itself.
     */
    public ServerKeyProperties withUri(String uri) {
        this.uri = uri;
        return this;
    }

    /**
     * Get the thumbprint property: Thumbprint of the server key.
     * 
     * @return the thumbprint value.
     */
    public String thumbprint() {
        return this.thumbprint;
    }

    /**
     * Get the creationDate property: The server key creation date.
     * 
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    /**
     * Get the autoRotationEnabled property: Key auto rotation opt-in flag. Either true or false.
     * 
     * @return the autoRotationEnabled value.
     */
    public Boolean autoRotationEnabled() {
        return this.autoRotationEnabled;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (serverKeyType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property serverKeyType in model ServerKeyProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ServerKeyProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serverKeyType", this.serverKeyType == null ? null : this.serverKeyType.toString());
        jsonWriter.writeStringField("uri", this.uri);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerKeyProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerKeyProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ServerKeyProperties.
     */
    public static ServerKeyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerKeyProperties deserializedServerKeyProperties = new ServerKeyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serverKeyType".equals(fieldName)) {
                    deserializedServerKeyProperties.serverKeyType = ServerKeyType.fromString(reader.getString());
                } else if ("subregion".equals(fieldName)) {
                    deserializedServerKeyProperties.subregion = reader.getString();
                } else if ("uri".equals(fieldName)) {
                    deserializedServerKeyProperties.uri = reader.getString();
                } else if ("thumbprint".equals(fieldName)) {
                    deserializedServerKeyProperties.thumbprint = reader.getString();
                } else if ("creationDate".equals(fieldName)) {
                    deserializedServerKeyProperties.creationDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("autoRotationEnabled".equals(fieldName)) {
                    deserializedServerKeyProperties.autoRotationEnabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerKeyProperties;
        });
    }
}
